/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.integration.Integrator1D;
import java.util.function.Function;

public class RungeKuttaIntegrator1D
extends Integrator1D<Double, Double> {
    private static final double DEF_TOL = 1.0E-10;
    private static final double STEP_SIZE_LIMIT = 1.0E-50;
    private static final int DEF_MIN_STEPS = 10;
    private final double _absTol;
    private final double _relTol;
    private final int _minSteps;

    public RungeKuttaIntegrator1D(double absTol, double relTol, int minSteps) {
        if (absTol < 0.0 || Double.isNaN(absTol) || Double.isInfinite(absTol)) {
            throw new IllegalArgumentException("Absolute Tolerance must be greater than zero");
        }
        if (relTol < 0.0 || Double.isNaN(relTol) || Double.isInfinite(relTol)) {
            throw new IllegalArgumentException("Relative Tolerance must be greater than zero");
        }
        if (minSteps < 1) {
            throw new IllegalArgumentException("Must have minimum of 1 step");
        }
        this._absTol = absTol;
        this._relTol = relTol;
        this._minSteps = minSteps;
    }

    public RungeKuttaIntegrator1D(double tol, int minSteps) {
        this(tol, tol, minSteps);
    }

    public RungeKuttaIntegrator1D(double atol, double rtol) {
        this(atol, rtol, 10);
    }

    public RungeKuttaIntegrator1D(double tol) {
        this(tol, tol, 10);
    }

    public RungeKuttaIntegrator1D(int minSteps) {
        this(1.0E-10, minSteps);
    }

    public RungeKuttaIntegrator1D() {
        this(1.0E-10, 10);
    }

    public double getRelativeTolerance() {
        return this._relTol;
    }

    @Override
    public Double integrate(Function<Double, Double> f, Double lower, Double upper) {
        ArgChecker.notNull((Object)lower, (String)"lower");
        ArgChecker.notNull((Object)upper, (String)"upper");
        if (Double.isNaN(lower) || Double.isInfinite(lower) || Double.isInfinite(upper) || Double.isNaN(upper)) {
            throw new IllegalArgumentException("lower or upper was NaN or Inf");
        }
        double h = (upper - lower) / (double)this._minSteps;
        double x = lower;
        double f1 = f.apply(x);
        if (Double.isNaN(f1) || Double.isInfinite(f1)) {
            throw new IllegalArgumentException("function evaluation returned NaN or Inf");
        }
        double result = 0.0;
        for (int i = 0; i < this._minSteps; ++i) {
            double f2 = f.apply(x + h / 2.0);
            if (Double.isNaN(f2) || Double.isInfinite(f2)) {
                throw new IllegalArgumentException("function evaluation returned NaN or Inf");
            }
            double f3 = f.apply(x + h);
            if (Double.isNaN(f3) || Double.isInfinite(f3)) {
                throw new IllegalArgumentException("function evaluation returned NaN or Inf");
            }
            result += this.calculateRungeKuttaFourthOrder(f, x, h, f1, f2, f3);
            f1 = f3;
            x += h;
        }
        return result;
    }

    private double calculateRungeKuttaFourthOrder(Function<Double, Double> f, double x, double h, double fl, double fm, double fu) {
        double abs;
        double f1 = f.apply(x + 0.25 * h);
        if (Double.isNaN(f1) || Double.isInfinite(f1)) {
            throw new IllegalStateException("f.evaluate returned NaN or Inf");
        }
        double f2 = f.apply(x + 0.75 * h);
        if (Double.isNaN(f2) || Double.isInfinite(f2)) {
            throw new IllegalStateException("f.evaluate returned NaN or Inf");
        }
        double ya = h * (fl + 4.0 * fm + fu) / 6.0;
        double yb = h * (fl + 2.0 * fm + 4.0 * (f1 + f2) + fu) / 12.0;
        double diff = Math.abs(ya - yb);
        if (diff < this._absTol + this._relTol * (abs = Math.max(Math.abs(ya), Math.abs(yb)))) {
            return yb + (yb - ya) / 15.0;
        }
        if (h < 1.0E-50) {
            return yb + (yb - ya) / 15.0;
        }
        return this.calculateRungeKuttaFourthOrder(f, x, h / 2.0, fl, f1, fm) + this.calculateRungeKuttaFourthOrder(f, x + h / 2.0, h / 2.0, fm, f2, fu);
    }
}

