/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.integration;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.integration.Integrator1D;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import java.util.function.Function;
import org.apache.commons.math3.analysis.integration.SimpsonIntegrator;
import org.apache.commons.math3.analysis.integration.UnivariateIntegrator;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpsonIntegrator1D
extends Integrator1D<Double, Double> {
    private static final Logger log = LoggerFactory.getLogger(SimpsonIntegrator1D.class);
    private static final int MAX_EVAL = 1000;
    private final UnivariateIntegrator integrator = new SimpsonIntegrator();

    @Override
    public Double integrate(Function<Double, Double> f, Double lower, Double upper) {
        ArgChecker.notNull(f, (String)"function");
        ArgChecker.notNull((Object)lower, (String)"lower bound");
        ArgChecker.notNull((Object)upper, (String)"upper bound");
        try {
            if (lower < upper) {
                return this.integrator.integrate(1000, CommonsMathWrapper.wrapUnivariate(f), lower.doubleValue(), upper.doubleValue());
            }
            log.info("Upper bound was less than lower bound; swapping bounds and negating result");
            return -this.integrator.integrate(1000, CommonsMathWrapper.wrapUnivariate(f), upper.doubleValue(), lower.doubleValue());
        }
        catch (NumberIsTooLargeException | NumberIsTooSmallException e) {
            throw new MathException(e);
        }
    }
}

