/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.FunctionUtils;
import com.opengamma.strata.math.impl.interpolation.BasisFunctionKnots;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class BasisFunctionGenerator {
    public List<Function<Double, Double>> generateSet(BasisFunctionKnots knots) {
        ArgChecker.notNull((Object)knots, (String)"knots");
        double[] k = knots.getKnots();
        List<Function<Double, Double>> set = null;
        for (int d = 0; d <= knots.getDegree(); ++d) {
            set = this.generateSet(k, d, set);
        }
        return set;
    }

    public List<Function<double[], Double>> generateSet(BasisFunctionKnots[] knots) {
        ArgChecker.noNulls((Object[])knots, (String)"knots");
        int dim = knots.length;
        int[] nSplines = new int[dim];
        int product = 1;
        ArrayList<List<Function<Double, Double>>> oneDSets = new ArrayList<List<Function<Double, Double>>>(dim);
        for (int i = 0; i < dim; ++i) {
            oneDSets.add(this.generateSet(knots[i]));
            nSplines[i] = knots[i].getNumSplines();
            product *= nSplines[i];
        }
        ArrayList<Function<double[], Double>> functions = new ArrayList<Function<double[], Double>>(product);
        for (int i = 0; i < product; ++i) {
            int[] indices = FunctionUtils.fromTensorIndex(i, nSplines);
            functions.add(this.generateMultiDim(oneDSets, indices));
        }
        return functions;
    }

    protected Function<Double, Double> generate(BasisFunctionKnots data, int index) {
        ArgChecker.notNull((Object)data, (String)"data");
        ArgChecker.isTrue((index >= 0 && index < data.getNumSplines() ? 1 : 0) != 0, (String)"index must be in range {} to {} (exclusive)", (Object[])new Object[]{0, data.getNumSplines()});
        return this.generate(data.getKnots(), data.getDegree(), index);
    }

    private Function<double[], Double> generateMultiDim(List<List<Function<Double, Double>>> oneDSets, int[] index) {
        final int dim = index.length;
        final ArrayList<Function<Double, Double>> funcs = new ArrayList<Function<Double, Double>>(dim);
        for (int i = 0; i < dim; ++i) {
            funcs.add(oneDSets.get(i).get(index[i]));
        }
        return new Function<double[], Double>(){

            @Override
            public Double apply(double[] x) {
                double product = 1.0;
                ArgChecker.isTrue((dim == x.length ? 1 : 0) != 0, (String)"length of x {} was not equal to dimension {}", (Object[])new Object[]{x.length, dim});
                for (int i = 0; i < dim; ++i) {
                    product *= ((Double)((Function)funcs.get(i)).apply(x[i])).doubleValue();
                }
                return product;
            }
        };
    }

    private List<Function<Double, Double>> generateSet(double[] knots, int degree, List<Function<Double, Double>> degreeM1Set) {
        int nSplines = knots.length - degree - 1;
        ArrayList<Function<Double, Double>> functions = new ArrayList<Function<Double, Double>>(nSplines);
        for (int i = 0; i < nSplines; ++i) {
            functions.add(this.generate(knots, degree, i, degreeM1Set));
        }
        return functions;
    }

    private Function<Double, Double> generate(final double[] knots, final int degree, final int index, List<Function<Double, Double>> degreeM1Set) {
        if (degree == 0) {
            return new Function<Double, Double>(){
                private final double _l;
                private final double _h;
                {
                    this._l = knots[index];
                    this._h = knots[index + 1];
                }

                @Override
                public Double apply(Double x) {
                    return x >= this._l && x < this._h ? 1.0 : 0.0;
                }
            };
        }
        if (degree == 1) {
            return new Function<Double, Double>(){
                private final double _l;
                private final double _m;
                private final double _h;
                private final double _inv1;
                private final double _inv2;
                {
                    this._l = knots[index];
                    this._m = knots[index + 1];
                    this._h = knots[index + 2];
                    this._inv1 = 1.0 / (knots[index + 1] - knots[index]);
                    this._inv2 = 1.0 / (knots[index + 2] - knots[index + 1]);
                }

                @Override
                public Double apply(Double x) {
                    return x <= this._l || x >= this._h ? 0.0 : (x <= this._m ? (x - this._l) * this._inv1 : (this._h - x) * this._inv2);
                }
            };
        }
        final Function<Double, Double> fa = degreeM1Set == null ? this.generate(knots, degree - 1, index) : degreeM1Set.get(index);
        final Function<Double, Double> fb = degreeM1Set == null ? this.generate(knots, degree - 1, index + 1) : degreeM1Set.get(index + 1);
        return new Function<Double, Double>(){
            private final double _inv1;
            private final double _inv2;
            private final double _xa;
            private final double _xb;
            {
                this._inv1 = 1.0 / (knots[index + degree] - knots[index]);
                this._inv2 = 1.0 / (knots[index + degree + 1] - knots[index + 1]);
                this._xa = knots[index];
                this._xb = knots[index + degree + 1];
            }

            @Override
            public Double apply(Double x) {
                return (x - this._xa) * this._inv1 * (Double)fa.apply(x) + (this._xb - x) * this._inv2 * (Double)fb.apply(x);
            }
        };
    }

    private Function<Double, Double> generate(double[] knots, int degree, int index) {
        return this.generate(knots, degree, index, null);
    }
}

