/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import com.opengamma.strata.math.impl.interpolation.ProductPiecewisePolynomialInterpolator;
import java.util.Arrays;

public class ClampedPiecewisePolynomialInterpolator
extends PiecewisePolynomialInterpolator {
    private final PiecewisePolynomialInterpolator _baseMethod;
    private final double[] _xValuesClamped;
    private final double[] _yValuesClamped;

    public ClampedPiecewisePolynomialInterpolator(PiecewisePolynomialInterpolator baseMethod, double[] xValuesClamped, double[] yValuesClamped) {
        ArgChecker.notNull((Object)baseMethod, (String)"method");
        ArgChecker.notEmpty((double[])xValuesClamped, (String)"xValuesClamped");
        ArgChecker.notEmpty((double[])yValuesClamped, (String)"yValuesClamped");
        ArgChecker.isFalse((boolean)(baseMethod instanceof ProductPiecewisePolynomialInterpolator), (String)"baseMethod should not be ProductPiecewisePolynomialInterpolator");
        int nExtraPoints = xValuesClamped.length;
        ArgChecker.isTrue((yValuesClamped.length == nExtraPoints ? 1 : 0) != 0, (String)"xValuesClamped and yValuesClamped should be the same length");
        this._baseMethod = baseMethod;
        this._xValuesClamped = Arrays.copyOf(xValuesClamped, nExtraPoints);
        this._yValuesClamped = Arrays.copyOf(yValuesClamped, nExtraPoints);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"xValues length = yValues length");
        double[][] xyValuesAll = this.getDataTotal(xValues, yValues);
        return this._baseMethod.interpolate(xyValuesAll[0], xyValuesAll[1]);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        throw new UnsupportedOperationException("Use 1D interpolation method");
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"xValues length = yValues length");
        double[][] xyValuesAll = this.getDataTotal(xValues, yValues);
        return this._baseMethod.interpolateWithSensitivity(xyValuesAll[0], xyValuesAll[1]);
    }

    @Override
    public PiecewisePolynomialInterpolator getPrimaryMethod() {
        return this._baseMethod;
    }

    private double[][] getDataTotal(double[] xData, double[] yData) {
        int nExtraPoints = this._xValuesClamped.length;
        int nData = xData.length;
        int nTotal = nExtraPoints + nData;
        double[] xValuesTotal = new double[nTotal];
        double[] yValuesTotal = new double[nTotal];
        System.arraycopy(xData, 0, xValuesTotal, 0, nData);
        System.arraycopy(yData, 0, yValuesTotal, 0, nData);
        System.arraycopy(this._xValuesClamped, 0, xValuesTotal, nData, nExtraPoints);
        System.arraycopy(this._yValuesClamped, 0, yValuesTotal, nData, nExtraPoints);
        DoubleArrayMath.sortPairs((double[])xValuesTotal, (double[])yValuesTotal);
        return new double[][]{xValuesTotal, yValuesTotal};
    }
}

