/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.CubicSplineSolver;

public class CubicSplineClampedSolver
extends CubicSplineSolver {
    private double[] _iniConds;
    private double[] _finConds;
    private double _iniCondUse;
    private double _finCondUse;

    public CubicSplineClampedSolver(double iniCond, double finCond) {
        this._iniCondUse = iniCond;
        this._finCondUse = finCond;
    }

    public CubicSplineClampedSolver(double[] iniConds, double[] finConds) {
        this._iniConds = iniConds;
        this._finConds = finConds;
    }

    @Override
    public DoubleMatrix solve(double[] xValues, double[] yValues) {
        double[] intervals = this.getDiffs(xValues);
        return this.getCommonSplineCoeffs(xValues, yValues, intervals, this.matrixEqnSolver(this.getMatrix(intervals), this.getVector(yValues, intervals)));
    }

    @Override
    public DoubleMatrix[] solveWithSensitivity(double[] xValues, double[] yValues) {
        double[] intervals = this.getDiffs(xValues);
        double[][] toBeInv = this.getMatrix(intervals);
        double[] vector = this.getVector(yValues, intervals);
        double[][] vecSensitivity = this.getVectorSensitivity(intervals);
        return this.getCommonCoefficientWithSensitivity(xValues, yValues, intervals, toBeInv, vector, vecSensitivity);
    }

    @Override
    public DoubleMatrix[] solveMultiDim(double[] xValues, DoubleMatrix yValuesMatrix) {
        int dim = yValuesMatrix.rowCount();
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        for (int i = 0; i < dim; ++i) {
            this.resetConds(i);
            coefMatrix[i] = this.solve(xValues, yValuesMatrix.row(i).toArray());
        }
        return coefMatrix;
    }

    private void resetConds(int i) {
        this._iniCondUse = this._iniConds[i];
        this._finCondUse = this._finConds[i];
    }

    private double[][] getMatrix(double[] intervals) {
        int nData = intervals.length + 1;
        double[][] res = new double[nData][nData];
        res = this.getCommonMatrixElements(intervals);
        res[0][0] = 2.0 * intervals[0];
        res[0][1] = intervals[0];
        res[nData - 1][nData - 2] = intervals[nData - 2];
        res[nData - 1][nData - 1] = 2.0 * intervals[nData - 2];
        return res;
    }

    private double[] getVector(double[] yValues, double[] intervals) {
        int nData = yValues.length;
        double[] res = new double[nData];
        res = this.getCommonVectorElements(yValues, intervals);
        res[0] = 6.0 * yValues[1] / intervals[0] - 6.0 * yValues[0] / intervals[0] - 6.0 * this._iniCondUse;
        res[nData - 1] = 6.0 * this._finCondUse - 6.0 * yValues[nData - 1] / intervals[nData - 2] + 6.0 * yValues[nData - 2] / intervals[nData - 2];
        return res;
    }

    private double[][] getVectorSensitivity(double[] intervals) {
        int nData = intervals.length + 1;
        double[][] res = new double[nData][nData];
        res = this.getCommonVectorSensitivity(intervals);
        res[0][0] = -6.0 / intervals[0];
        res[0][1] = 6.0 / intervals[0];
        res[nData - 1][nData - 1] = -6.0 / intervals[nData - 2];
        res[nData - 1][nData - 2] = 6.0 / intervals[nData - 2];
        return res;
    }
}

