/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.CubicSplineClampedSolver;
import com.opengamma.strata.math.impl.interpolation.CubicSplineNakSolver;
import com.opengamma.strata.math.impl.interpolation.CubicSplineSolver;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;
import java.util.stream.IntStream;

public class CubicSplineInterpolator
extends PiecewisePolynomialInterpolator {
    private CubicSplineSolver _solver;

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        double[] yValuesSrt;
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((boolean)(xValues.length == yValues.length | xValues.length + 2 == yValues.length), (String)"(xValues length = yValues length) or (xValues length + 2 = yValues length)");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be more than 1");
        int nDataPts = xValues.length;
        int nYdata = yValues.length;
        for (i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xData containing Infinity");
        }
        for (i = 0; i < nYdata; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yData containing Infinity");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        if (xValues.length + 2 == yValues.length) {
            this._solver = new CubicSplineClampedSolver(yValues[0], yValues[nDataPts + 1]);
            yValuesSrt = Arrays.copyOfRange(yValues, 1, nDataPts + 1);
        } else {
            this._solver = new CubicSplineNakSolver();
            yValuesSrt = Arrays.copyOf(yValues, nDataPts);
        }
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix coefMatrix = this._solver.solve(xValuesSrt, yValuesSrt);
        int nCoefs = coefMatrix.columnCount();
        DoubleArray knotsMat1D = this._solver.getKnotsMat1D(xValuesSrt);
        for (int i2 = 0; i2 < knotsMat1D.size() - 1; ++i2) {
            for (int j = 0; j < nCoefs; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix.get(i2, j)), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix.get(i2, j)), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(knotsMat1D, coefMatrix, nCoefs, 1);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        int j;
        int i;
        int i2;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValuesMatrix, (String)"yValuesMatrix");
        ArgChecker.isTrue((boolean)(xValues.length == yValuesMatrix[0].length | xValues.length + 2 == yValuesMatrix[0].length), (String)"(xValues length = yValuesMatrix's row vector length) or (xValues length + 2 = yValuesMatrix's row vector length)");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be more than 1");
        int nDataPts = xValues.length;
        int nYdata = yValuesMatrix[0].length;
        int dim = yValuesMatrix.length;
        for (i2 = 0; i2 < nDataPts; ++i2) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i2]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i2]), (String)"xData containing Infinity");
        }
        for (i2 = 0; i2 < nYdata; ++i2) {
            for (int j2 = 0; j2 < dim; ++j2) {
                ArgChecker.isFalse((boolean)Double.isNaN(yValuesMatrix[j2][i2]), (String)"yValuesMatrix containing NaN");
                ArgChecker.isFalse((boolean)Double.isInfinite(yValuesMatrix[j2][i2]), (String)"yValuesMatrix containing Infinity");
            }
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[][] yValuesMatrixSrt = new double[dim][nDataPts];
        int[] sortedPositions = IntStream.range(0, nDataPts).toArray();
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (int[])sortedPositions);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        if (xValues.length + 2 == yValuesMatrix[0].length) {
            int i3;
            double[] iniConds = new double[dim];
            double[] finConds = new double[dim];
            for (i3 = 0; i3 < dim; ++i3) {
                iniConds[i3] = yValuesMatrix[i3][0];
                finConds[i3] = yValuesMatrix[i3][nDataPts + 1];
            }
            this._solver = new CubicSplineClampedSolver(iniConds, finConds);
            for (i3 = 0; i3 < dim; ++i3) {
                double[] yValuesSrt = Arrays.copyOfRange(yValuesMatrix[i3], 1, nDataPts + 1);
                yValuesMatrixSrt[i3] = DoubleArrayMath.reorderedCopy((double[])yValuesSrt, (int[])sortedPositions);
            }
        } else {
            this._solver = new CubicSplineNakSolver();
            for (int i4 = 0; i4 < dim; ++i4) {
                yValuesMatrixSrt[i4] = DoubleArrayMath.reorderedCopy((double[])yValuesMatrix[i4], (int[])sortedPositions);
            }
        }
        DoubleMatrix[] coefMatrix = this._solver.solveMultiDim(xValuesSrt, DoubleMatrix.copyOf((double[][])yValuesMatrixSrt));
        int nIntervals = coefMatrix[0].rowCount();
        int nCoefs = coefMatrix[0].columnCount();
        double[][] resMatrix = new double[dim * nIntervals][nCoefs];
        for (i = 0; i < nIntervals; ++i) {
            for (j = 0; j < dim; ++j) {
                resMatrix[dim * i + j] = coefMatrix[j].row(i).toArray();
            }
        }
        for (i = 0; i < dim * nIntervals; ++i) {
            for (j = 0; j < nCoefs; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(resMatrix[i][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(resMatrix[i][j]), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(this._solver.getKnotsMat1D(xValuesSrt), DoubleMatrix.copyOf((double[][])resMatrix), nCoefs, dim);
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        double[] yValuesSrt;
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((boolean)(xValues.length == yValues.length | xValues.length + 2 == yValues.length), (String)"(xValues length = yValues length) or (xValues length + 2 = yValues length)");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be more than 1");
        int nDataPts = xValues.length;
        int nYdata = yValues.length;
        for (i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xData containing Infinity");
        }
        for (i = 0; i < nYdata; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yData containing Infinity");
        }
        ArgChecker.noDuplicates((double[])xValues, (String)"xValues");
        if (xValues.length + 2 == yValues.length) {
            this._solver = new CubicSplineClampedSolver(yValues[0], yValues[nDataPts + 1]);
            yValuesSrt = Arrays.copyOfRange(yValues, 1, nDataPts + 1);
        } else {
            this._solver = new CubicSplineNakSolver();
            yValuesSrt = Arrays.copyOf(yValues, nDataPts);
        }
        DoubleMatrix[] resMatrix = this._solver.solveWithSensitivity(xValues, yValuesSrt);
        int len = resMatrix.length;
        for (int k = 0; k < len; ++k) {
            DoubleMatrix m = resMatrix[k];
            int rows = m.rowCount();
            int cols = m.columnCount();
            for (int i2 = 0; i2 < rows; ++i2) {
                for (int j = 0; j < cols; ++j) {
                    ArgChecker.isTrue((boolean)Doubles.isFinite((double)m.get(i2, j)), (String)"Matrix contains a NaN or infinite");
                }
            }
        }
        DoubleMatrix coefMatrix = resMatrix[0];
        DoubleMatrix[] coefSenseMatrix = new DoubleMatrix[len - 1];
        System.arraycopy(resMatrix, 1, coefSenseMatrix, 0, len - 1);
        int nCoefs = coefMatrix.columnCount();
        return new PiecewisePolynomialResultsWithSensitivity(this._solver.getKnotsMat1D(xValues), coefMatrix, nCoefs, 1, coefSenseMatrix);
    }
}

