/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.linearalgebra.LUDecompositionCommons;
import com.opengamma.strata.math.impl.linearalgebra.LUDecompositionResult;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebraFactory;
import com.opengamma.strata.math.linearalgebra.Decomposition;
import java.util.Arrays;

abstract class CubicSplineSolver {
    private final Decomposition<LUDecompositionResult> _luObj = new LUDecompositionCommons();

    CubicSplineSolver() {
    }

    public abstract DoubleMatrix solve(double[] var1, double[] var2);

    public abstract DoubleMatrix[] solveWithSensitivity(double[] var1, double[] var2);

    public abstract DoubleMatrix[] solveMultiDim(double[] var1, DoubleMatrix var2);

    public DoubleArray getKnotsMat1D(double[] xValues) {
        return DoubleArray.copyOf((double[])xValues);
    }

    protected double[] getDiffs(double[] xValues) {
        int nDataPts = xValues.length;
        double[] res = new double[nDataPts - 1];
        for (int i = 0; i < nDataPts - 1; ++i) {
            res[i] = xValues[i + 1] - xValues[i];
        }
        return res;
    }

    protected DoubleMatrix getCommonSplineCoeffs(double[] xValues, double[] yValues, double[] intervals, double[] solnVector) {
        int nDataPts = xValues.length;
        double[][] res = new double[nDataPts - 1][4];
        for (int i = 0; i < nDataPts - 1; ++i) {
            res[i][0] = solnVector[i + 1] / 6.0 / intervals[i] - solnVector[i] / 6.0 / intervals[i];
            res[i][1] = 0.5 * solnVector[i];
            res[i][2] = yValues[i + 1] / intervals[i] - yValues[i] / intervals[i] - intervals[i] * solnVector[i] / 2.0 - intervals[i] * solnVector[i + 1] / 6.0 + intervals[i] * solnVector[i] / 6.0;
            res[i][3] = yValues[i];
        }
        return DoubleMatrix.copyOf((double[][])res);
    }

    protected DoubleMatrix[] getCommonSensitivityCoeffs(double[] intervals, double[][] solnMatrix) {
        int nDataPts = intervals.length + 1;
        double[][][] res = new double[nDataPts - 1][4][nDataPts];
        for (int i = 0; i < nDataPts - 1; ++i) {
            res[i][3][i] = 1.0;
            res[i][2][i + 1] = 1.0 / intervals[i];
            res[i][2][i] = -1.0 / intervals[i];
            for (int k = 0; k < nDataPts; ++k) {
                res[i][0][k] = solnMatrix[i + 1][k] / 6.0 / intervals[i] - solnMatrix[i][k] / 6.0 / intervals[i];
                res[i][1][k] = 0.5 * solnMatrix[i][k];
                double[] dArray = res[i][2];
                int n = k;
                dArray[n] = dArray[n] + (-intervals[i] * solnMatrix[i][k] / 2.0 - intervals[i] * solnMatrix[i + 1][k] / 6.0 + intervals[i] * solnMatrix[i][k] / 6.0);
            }
        }
        DoubleMatrix[] resMat = new DoubleMatrix[nDataPts - 1];
        for (int i = 0; i < nDataPts - 1; ++i) {
            resMat[i] = DoubleMatrix.copyOf((double[][])res[i]);
        }
        return resMat;
    }

    protected DoubleMatrix[] getCommonCoefficientWithSensitivity(double[] xValues, double[] yValues, double[] intervals, double[][] toBeInv, double[] commonVector, double[][] commonVecSensitivity) {
        int nDataPts = xValues.length;
        DoubleArray[] soln = this.combinedMatrixEqnSolver(toBeInv, commonVector, commonVecSensitivity);
        DoubleMatrix[] res = new DoubleMatrix[nDataPts];
        res[0] = this.getCommonSplineCoeffs(xValues, yValues, intervals, soln[0].toArray());
        double[][] solnMatrix = new double[nDataPts][nDataPts];
        for (int i = 0; i < nDataPts; ++i) {
            for (int j = 0; j < nDataPts; ++j) {
                solnMatrix[i][j] = soln[j + 1].get(i);
            }
        }
        DoubleMatrix[] tmp = this.getCommonSensitivityCoeffs(intervals, solnMatrix);
        System.arraycopy(tmp, 0, res, 1, nDataPts - 1);
        return res;
    }

    protected double[][] getCommonMatrixElements(double[] intervals) {
        int i;
        int nDataPts = intervals.length + 1;
        double[][] res = new double[nDataPts][nDataPts];
        for (i = 0; i < nDataPts; ++i) {
            Arrays.fill(res[i], 0.0);
        }
        for (i = 1; i < nDataPts - 1; ++i) {
            res[i][i - 1] = intervals[i - 1];
            res[i][i] = 2.0 * (intervals[i - 1] + intervals[i]);
            res[i][i + 1] = intervals[i];
        }
        return res;
    }

    protected double[] getCommonVectorElements(double[] yValues, double[] intervals) {
        int nDataPts = yValues.length;
        double[] res = new double[nDataPts];
        Arrays.fill(res, 0.0);
        for (int i = 1; i < nDataPts - 1; ++i) {
            res[i] = 6.0 * yValues[i + 1] / intervals[i] - 6.0 * yValues[i] / intervals[i] - 6.0 * yValues[i] / intervals[i - 1] + 6.0 * yValues[i - 1] / intervals[i - 1];
        }
        return res;
    }

    protected double[][] getCommonVectorSensitivity(double[] intervals) {
        int i;
        int nDataPts = intervals.length + 1;
        double[][] res = new double[nDataPts][nDataPts];
        for (i = 0; i < nDataPts; ++i) {
            Arrays.fill(res[i], 0.0);
        }
        for (i = 1; i < nDataPts - 1; ++i) {
            res[i][i - 1] = 6.0 / intervals[i - 1];
            res[i][i] = -6.0 / intervals[i] - 6.0 / intervals[i - 1];
            res[i][i + 1] = 6.0 / intervals[i];
        }
        return res;
    }

    protected double[] matrixEqnSolver(double[][] doubMat, double[] doubVec) {
        LUDecompositionResult result = this._luObj.apply(DoubleMatrix.copyOf((double[][])doubMat));
        double[][] lMat = result.getL().toArray();
        double[][] uMat = result.getU().toArray();
        DoubleArray doubVecMod = (DoubleArray)MatrixAlgebraFactory.OG_ALGEBRA.multiply((Matrix)result.getP(), (Matrix)DoubleArray.copyOf((double[])doubVec));
        return this.backSubstitution(uMat, this.forwardSubstitution(lMat, doubVecMod));
    }

    protected DoubleArray[] combinedMatrixEqnSolver(double[][] doubMat1, double[] doubVec, double[][] doubMat2) {
        int nDataPts = doubVec.length;
        LUDecompositionResult result = this._luObj.apply(DoubleMatrix.copyOf((double[][])doubMat1));
        double[][] lMat = result.getL().toArray();
        double[][] uMat = result.getU().toArray();
        DoubleMatrix pMat = result.getP();
        DoubleArray doubVecMod = (DoubleArray)MatrixAlgebraFactory.OG_ALGEBRA.multiply((Matrix)pMat, (Matrix)DoubleArray.copyOf((double[])doubVec));
        DoubleMatrix doubMat2Matrix = DoubleMatrix.copyOf((double[][])doubMat2);
        DoubleArray[] res = new DoubleArray[nDataPts + 1];
        res[0] = DoubleArray.copyOf((double[])this.backSubstitution(uMat, this.forwardSubstitution(lMat, doubVecMod)));
        for (int i = 0; i < nDataPts; ++i) {
            DoubleArray doubMat2Colum = doubMat2Matrix.column(i);
            DoubleArray doubVecMod2 = (DoubleArray)MatrixAlgebraFactory.OG_ALGEBRA.multiply((Matrix)pMat, (Matrix)doubMat2Colum);
            res[i + 1] = DoubleArray.copyOf((double[])this.backSubstitution(uMat, this.forwardSubstitution(lMat, doubVecMod2)));
        }
        return res;
    }

    private double[] forwardSubstitution(double[][] lMat, DoubleArray doubVec) {
        int size = lMat.length;
        double[] res = new double[size];
        for (int i = 0; i < size; ++i) {
            double tmp = doubVec.get(i) / lMat[i][i];
            for (int j = 0; j < i; ++j) {
                tmp -= lMat[i][j] * res[j] / lMat[i][i];
            }
            res[i] = tmp;
        }
        return res;
    }

    private double[] backSubstitution(double[][] uMat, double[] doubVec) {
        int size = uMat.length;
        double[] res = new double[size];
        for (int i = size - 1; i > -1; --i) {
            double tmp = doubVec[i] / uMat[i][i];
            for (int j = i + 1; j < size; ++j) {
                tmp -= uMat[i][j] * res[j] / uMat[i][i];
            }
            res[i] = tmp;
        }
        return res;
    }
}

