/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;
import java.util.stream.IntStream;

public class LinearInterpolator
extends PiecewisePolynomialInterpolator {
    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        ArgChecker.notEmpty((double[])xValues, (String)"xValues");
        ArgChecker.notEmpty((double[])yValues, (String)"yValues");
        int nDataPts = xValues.length;
        ArgChecker.isTrue((nDataPts > 1 ? 1 : 0) != 0, (String)"at least two data points required");
        ArgChecker.isTrue((nDataPts == yValues.length ? 1 : 0) != 0, (String)"xValues length = yValues length");
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xData containing Infinity");
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yData containing Infinity");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[] yValuesSrt = Arrays.copyOf(yValues, nDataPts);
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix coefMatrix = this.solve(xValuesSrt, yValuesSrt);
        for (int i = 0; i < coefMatrix.rowCount(); ++i) {
            int j;
            for (j = 0; j < coefMatrix.columnCount(); ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix.get(i, j)), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix.get(i, j)), (String)"Too large input");
            }
            for (j = 0; j < 2; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix.get(i, j)), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix.get(i, j)), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), coefMatrix, coefMatrix.columnCount(), 1);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        ArgChecker.notEmpty((double[])xValues, (String)"xValues");
        ArgChecker.notEmpty((Object[])yValuesMatrix, (String)"yValuesMatrix");
        int nDataPts = xValues.length;
        ArgChecker.isTrue((nDataPts > 1 ? 1 : 0) != 0, (String)"at least two data points required");
        ArgChecker.isTrue((nDataPts == yValuesMatrix[0].length ? 1 : 0) != 0, (String)"(xValues length = yValuesMatrix's row vector length)");
        int dim = yValuesMatrix.length;
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xData containing Infinity");
            for (double[] valuesMatrix : yValuesMatrix) {
                ArgChecker.isFalse((boolean)Double.isNaN(valuesMatrix[i]), (String)"yValuesMatrix containing NaN");
                ArgChecker.isFalse((boolean)Double.isInfinite(valuesMatrix[i]), (String)"yValuesMatrix containing Infinity");
            }
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        int[] sortedPositions = IntStream.range(0, nDataPts).toArray();
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (int[])sortedPositions);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        for (int i = 0; i < dim; ++i) {
            double[] yValuesSrt = DoubleArrayMath.reorderedCopy((double[])yValuesMatrix[i], (int[])sortedPositions);
            coefMatrix[i] = this.solve(xValuesSrt, yValuesSrt);
            for (int k = 0; k < xValuesSrt.length - 1; ++k) {
                for (int j = 0; j < 2; ++j) {
                    ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix[i].get(k, j)), (String)"Too large input");
                    ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix[i].get(k, j)), (String)"Too large input");
                }
            }
        }
        int nIntervals = coefMatrix[0].rowCount();
        int nCoefs = coefMatrix[0].columnCount();
        double[][] resMatrix = new double[dim * nIntervals][nCoefs];
        for (int i = 0; i < nIntervals; ++i) {
            for (int j = 0; j < dim; ++j) {
                resMatrix[dim * i + j] = coefMatrix[j].row(i).toArray();
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])resMatrix), nCoefs, dim);
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        ArgChecker.notEmpty((double[])xValues, (String)"xValues");
        ArgChecker.notEmpty((double[])yValues, (String)"yValues");
        int nDataPts = xValues.length;
        ArgChecker.isTrue((nDataPts > 1 ? 1 : 0) != 0, (String)"at least two data points required");
        ArgChecker.isTrue((nDataPts == yValues.length ? 1 : 0) != 0, (String)"xValues length = yValues length");
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xData containing Infinity");
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yData containing Infinity");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[] yValuesSrt = Arrays.copyOf(yValues, nDataPts);
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix[] res = this.solveSensitivity(xValuesSrt, yValuesSrt);
        DoubleMatrix coefMatrix = res[nDataPts - 1];
        DoubleMatrix[] coefSenseMatrix = Arrays.copyOf(res, nDataPts - 1);
        for (int i = 0; i < coefMatrix.rowCount(); ++i) {
            int j;
            for (j = 0; j < coefMatrix.columnCount(); ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix.get(i, j)), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix.get(i, j)), (String)"Too large input");
            }
            for (j = 0; j < 2; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix.get(i, j)), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix.get(i, j)), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResultsWithSensitivity(DoubleArray.ofUnsafe((double[])xValuesSrt), coefMatrix, coefMatrix.columnCount(), 1, coefSenseMatrix);
    }

    private DoubleMatrix solve(double[] xValues, double[] yValues) {
        int nDataPts = xValues.length;
        double[][] res = new double[nDataPts - 1][2];
        for (int i = 0; i < nDataPts - 1; ++i) {
            res[i][1] = yValues[i];
            res[i][0] = (yValues[i + 1] - yValues[i]) / (xValues[i + 1] - xValues[i]);
        }
        return DoubleMatrix.copyOf((double[][])res);
    }

    private DoubleMatrix[] solveSensitivity(double[] xValues, double[] yValues) {
        int nDataPts = xValues.length;
        DoubleMatrix[] res = new DoubleMatrix[nDataPts];
        double[][] coef = new double[nDataPts - 1][2];
        for (int i = 0; i < nDataPts - 1; ++i) {
            double[][] coefSensi = new double[2][nDataPts];
            double intervalInv = 1.0 / (xValues[i + 1] - xValues[i]);
            coef[i][1] = yValues[i];
            coef[i][0] = (yValues[i + 1] - yValues[i]) * intervalInv;
            coefSensi[1][i] = 1.0;
            coefSensi[0][i] = -intervalInv;
            coefSensi[0][i + 1] = intervalInv;
            res[i] = DoubleMatrix.ofUnsafe((double[][])coefSensi);
        }
        res[nDataPts - 1] = DoubleMatrix.ofUnsafe((double[][])coef);
        return res;
    }
}

