/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.CubicSplineSolver;
import com.opengamma.strata.math.impl.linearalgebra.TridiagonalMatrix;
import com.opengamma.strata.math.impl.linearalgebra.TridiagonalSolver;

public class LogCubicSplineNaturalSolver
extends CubicSplineSolver {
    @Override
    public DoubleMatrix solve(double[] xValues, double[] yValues) {
        double[] intervals = this.getDiffs(xValues);
        return this.getCommonSplineCoeffs(xValues, yValues, intervals, this.matrixEqnSolver(this.getMatrix(intervals), this.getCommonVectorElements(yValues, intervals)));
    }

    @Override
    public DoubleMatrix[] solveWithSensitivity(double[] xValues, double[] yValues) {
        double[] intervals = this.getDiffs(xValues);
        double[][] toBeInv = this.getMatrix(intervals);
        double[] commonVector = this.getCommonVectorElements(yValues, intervals);
        double[][] commonVecSensitivity = this.getCommonVectorSensitivity(intervals);
        return this.getCommonCoefficientWithSensitivity(xValues, yValues, intervals, toBeInv, commonVector, commonVecSensitivity);
    }

    @Override
    public DoubleMatrix[] solveMultiDim(double[] xValues, DoubleMatrix yValuesMatrix) {
        int dim = yValuesMatrix.rowCount();
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        for (int i = 0; i < dim; ++i) {
            coefMatrix[i] = this.solve(xValues, yValuesMatrix.row(i).toArray());
        }
        return coefMatrix;
    }

    private double[][] getMatrix(double[] intervals) {
        int nData = intervals.length + 1;
        double[][] res = new double[nData][nData];
        res = this.getCommonMatrixElements(intervals);
        res[0][0] = 1.0;
        res[nData - 1][nData - 1] = 1.0;
        return res;
    }

    @Override
    protected double[] matrixEqnSolver(double[][] doubMat, double[] doubVec) {
        int sizeM1 = doubMat.length - 1;
        double[] a = new double[sizeM1];
        double[] b = new double[sizeM1 + 1];
        double[] c = new double[sizeM1];
        for (int i = 0; i < sizeM1; ++i) {
            a[i] = doubMat[i][i + 1];
            b[i] = doubMat[i][i];
            c[i] = doubMat[i + 1][i];
        }
        b[sizeM1] = doubMat[sizeM1][sizeM1];
        TridiagonalMatrix m = new TridiagonalMatrix(b, a, c);
        return TridiagonalSolver.solvTriDag(m, doubVec);
    }

    @Override
    protected DoubleArray[] combinedMatrixEqnSolver(double[][] doubMat1, double[] doubVec, double[][] doubMat2) {
        int size = doubVec.length;
        DoubleArray[] res = new DoubleArray[size + 1];
        DoubleMatrix doubMat2Matrix = DoubleMatrix.copyOf((double[][])doubMat2);
        double[] u = new double[size - 1];
        double[] d = new double[size];
        double[] l = new double[size - 1];
        for (int i = 0; i < size - 1; ++i) {
            u[i] = doubMat1[i][i + 1];
            d[i] = doubMat1[i][i];
            l[i] = doubMat1[i + 1][i];
        }
        d[size - 1] = doubMat1[size - 1][size - 1];
        TridiagonalMatrix m = new TridiagonalMatrix(d, u, l);
        res[0] = DoubleArray.copyOf((double[])TridiagonalSolver.solvTriDag(m, doubVec));
        for (int i = 0; i < size; ++i) {
            DoubleArray doubMat2Colum = doubMat2Matrix.column(i);
            res[i + 1] = TridiagonalSolver.solvTriDag(m, doubMat2Colum);
        }
        return res;
    }
}

