/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.CubicSplineNaturalSolver;
import com.opengamma.strata.math.impl.interpolation.CubicSplineSolver;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;
import java.util.stream.IntStream;

public class NaturalSplineInterpolator
extends PiecewisePolynomialInterpolator {
    private CubicSplineSolver _solver;

    public NaturalSplineInterpolator() {
        this._solver = new CubicSplineNaturalSolver();
    }

    public NaturalSplineInterpolator(CubicSplineSolver inherit) {
        this._solver = inherit;
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"xValues length = yValues length");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be more than 1");
        int nDataPts = xValues.length;
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xData containing Infinity");
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yData containing Infinity");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[] yValuesSrt = Arrays.copyOf(yValues, nDataPts);
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix coefMatrix = this._solver.solve(xValuesSrt, yValuesSrt);
        int nCoefs = coefMatrix.columnCount();
        int nInts = this._solver.getKnotsMat1D(xValuesSrt).size() - 1;
        for (int i = 0; i < nInts; ++i) {
            for (int j = 0; j < nCoefs; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix.get(i, j)), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix.get(i, j)), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(this._solver.getKnotsMat1D(xValuesSrt), coefMatrix, nCoefs, 1);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        int j;
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValuesMatrix, (String)"yValuesMatrix");
        ArgChecker.isTrue((xValues.length == yValuesMatrix[0].length ? 1 : 0) != 0, (String)"(xValues length = yValuesMatrix's row vector length)");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be more than 1");
        int nDataPts = xValues.length;
        int dim = yValuesMatrix.length;
        for (int i2 = 0; i2 < nDataPts; ++i2) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i2]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i2]), (String)"xData containing Infinity");
            for (int j2 = 0; j2 < dim; ++j2) {
                ArgChecker.isFalse((boolean)Double.isNaN(yValuesMatrix[j2][i2]), (String)"yValuesMatrix containing NaN");
                ArgChecker.isFalse((boolean)Double.isInfinite(yValuesMatrix[j2][i2]), (String)"yValuesMatrix containing Infinity");
            }
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        int[] sortedPositions = IntStream.range(0, nDataPts).toArray();
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (int[])sortedPositions);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        double[][] yValuesMatrixSrt = new double[dim][nDataPts];
        for (int i3 = 0; i3 < dim; ++i3) {
            yValuesMatrixSrt[i3] = DoubleArrayMath.reorderedCopy((double[])yValuesMatrix[i3], (int[])sortedPositions);
        }
        DoubleMatrix[] coefMatrix = this._solver.solveMultiDim(xValuesSrt, DoubleMatrix.copyOf((double[][])yValuesMatrixSrt));
        int nIntervals = coefMatrix[0].rowCount();
        int nCoefs = coefMatrix[0].columnCount();
        double[][] resMatrix = new double[dim * nIntervals][nCoefs];
        for (i = 0; i < nIntervals; ++i) {
            for (j = 0; j < dim; ++j) {
                resMatrix[dim * i + j] = coefMatrix[j].row(i).toArray();
            }
        }
        for (i = 0; i < dim * nIntervals; ++i) {
            for (j = 0; j < nCoefs; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(resMatrix[i][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(resMatrix[i][j]), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(this._solver.getKnotsMat1D(xValuesSrt), DoubleMatrix.copyOf((double[][])resMatrix), nCoefs, dim);
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"(xValues length = yValues length)");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be more than 1");
        int nDataPts = xValues.length;
        int nYdata = yValues.length;
        for (i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xData containing Infinity");
        }
        for (i = 0; i < nYdata; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yData containing Infinity");
        }
        ArgChecker.noDuplicates((double[])xValues, (String)"xValues");
        DoubleMatrix[] resMatrix = this._solver.solveWithSensitivity(xValues, yValues);
        int len = resMatrix.length;
        for (int k = 0; k < len; ++k) {
            DoubleMatrix m = resMatrix[k];
            int rows = m.rowCount();
            int cols = m.columnCount();
            for (int i2 = 0; i2 < rows; ++i2) {
                for (int j = 0; j < cols; ++j) {
                    ArgChecker.isTrue((boolean)Doubles.isFinite((double)m.get(i2, j)), (String)"Matrix contains a NaN or infinite");
                }
            }
        }
        DoubleMatrix coefMatrix = resMatrix[0];
        DoubleMatrix[] coefSenseMatrix = new DoubleMatrix[len - 1];
        System.arraycopy(resMatrix, 1, coefSenseMatrix, 0, len - 1);
        int nCoefs = coefMatrix.columnCount();
        return new PiecewisePolynomialResultsWithSensitivity(this._solver.getKnotsMat1D(xValues), coefMatrix, nCoefs, 1, coefSenseMatrix);
    }
}

