/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.math.impl.interpolation.BasisFunctionGenerator;
import com.opengamma.strata.math.impl.interpolation.BasisFunctionKnots;
import com.opengamma.strata.math.impl.statistics.leastsquare.GeneralizedLeastSquare;
import com.opengamma.strata.math.impl.statistics.leastsquare.GeneralizedLeastSquareResults;
import java.util.List;

public class PSplineFitter {
    private final BasisFunctionGenerator _generator = new BasisFunctionGenerator();
    private final GeneralizedLeastSquare _gls = new GeneralizedLeastSquare();

    public GeneralizedLeastSquareResults<Double> solve(List<Double> x, List<Double> y, List<Double> sigma, double xa, double xb, int nKnots, int degree, double lambda, int differenceOrder) {
        List bSplines = this._generator.generateSet(BasisFunctionKnots.fromUniform(xa, xb, nKnots, degree));
        return this._gls.solve(x, y, sigma, bSplines, lambda, differenceOrder);
    }

    public GeneralizedLeastSquareResults<double[]> solve(List<double[]> x, List<Double> y, List<Double> sigma, double[] xa, double[] xb, int[] nKnots, int[] degree, double[] lambda, int[] differenceOrder) {
        BasisFunctionKnots[] knots = new BasisFunctionKnots[xa.length];
        for (int i = 0; i < xa.length; ++i) {
            knots[i] = BasisFunctionKnots.fromUniform(xa[i], xb[i], nKnots[i], degree[i]);
        }
        List bSplines = this._generator.generateSet(knots);
        int dim = xa.length;
        int[] sizes = new int[dim];
        for (int i = 0; i < dim; ++i) {
            sizes[i] = nKnots[i] + degree[i] - 1;
        }
        return this._gls.solve(x, y, sigma, bSplines, sizes, lambda, differenceOrder);
    }
}

