/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import org.apache.commons.math3.util.CombinatoricsUtils;

public abstract class PenaltyMatrixGenerator {
    private static final MatrixAlgebra MA = new OGMatrixAlgebra();

    public static DoubleMatrix getDifferenceMatrix(int m, int k) {
        ArgChecker.notNegativeOrZero((int)m, (String)"m");
        ArgChecker.notNegative((int)k, (String)"k");
        ArgChecker.isTrue((k < m ? 1 : 0) != 0, (String)"Difference order too high, require m > k, but have: m = {} and k = {}", (Object[])new Object[]{m, k});
        if (k == 0) {
            return DoubleMatrix.identity((int)m);
        }
        int[] coeff = new int[k + 1];
        int sign = 1;
        for (int i = k; i >= 0; --i) {
            coeff[i] = (int)((long)sign * CombinatoricsUtils.binomialCoefficient((int)k, (int)i));
            sign = -sign;
        }
        double[][] data = new double[m][m];
        for (int i = k; i < m; ++i) {
            for (int j = 0; j < k + 1; ++j) {
                data[i][j + i - k] = coeff[j];
            }
        }
        return DoubleMatrix.ofUnsafe((double[][])data);
    }

    public static DoubleMatrix getPenaltyMatrix(int m, int k) {
        ArgChecker.notNegativeOrZero((int)m, (String)"m");
        ArgChecker.notNegative((int)k, (String)"k");
        ArgChecker.isTrue((k < m ? 1 : 0) != 0, (String)"Difference order too high, require m > k, but have: m = {} and k = {}", (Object[])new Object[]{m, k});
        if (k == 0) {
            return DoubleMatrix.identity((int)m);
        }
        DoubleMatrix d = PenaltyMatrixGenerator.getDifferenceMatrix(m, k);
        DoubleMatrix dt = MA.getTranspose((Matrix)d);
        return (DoubleMatrix)MA.multiply((Matrix)dt, (Matrix)d);
    }

    public static DoubleMatrix getPenaltyMatrix(int[] numElements, int k, int index) {
        ArgChecker.notEmpty((int[])numElements, (String)"size");
        ArgChecker.isTrue((index >= 0 && index < numElements.length ? 1 : 0) != 0, (String)"index must be in range 0 to {}", (long)numElements.length);
        DoubleMatrix d = PenaltyMatrixGenerator.getPenaltyMatrix(numElements[index], k);
        return PenaltyMatrixGenerator.getMatrixForFlattened(numElements, d, index);
    }

    public static DoubleMatrix getPenaltyMatrix(int[] numElements, int[] k, double[] lambda) {
        ArgChecker.notEmpty((int[])numElements, (String)"size");
        ArgChecker.notEmpty((int[])k, (String)"k");
        ArgChecker.notEmpty((double[])lambda, (String)"lambda");
        int dim = numElements.length;
        ArgChecker.isTrue((dim == k.length ? 1 : 0) != 0, (String)"k different length to size");
        ArgChecker.isTrue((dim == lambda.length ? 1 : 0) != 0, (String)"lambda different lenght to size");
        DoubleMatrix p = (DoubleMatrix)MA.scale((Matrix)PenaltyMatrixGenerator.getPenaltyMatrix(numElements, k[0], 0), lambda[0]);
        for (int i = 1; i < dim; ++i) {
            DoubleMatrix temp = (DoubleMatrix)MA.scale((Matrix)PenaltyMatrixGenerator.getPenaltyMatrix(numElements, k[i], i), lambda[i]);
            p = (DoubleMatrix)MA.add((Matrix)p, (Matrix)temp);
        }
        return p;
    }

    public static DoubleMatrix getDerivativeMatrix(double[] x, int k, boolean includeEnds) {
        ArgChecker.notEmpty((double[])x, (String)"x");
        ArgChecker.notNegative((int)k, (String)"k");
        int size = x.length;
        ArgChecker.isTrue((k < size ? 1 : 0) != 0, (String)"order too high. Length of x is {}, and k is {}", (Object[])new Object[]{size, k});
        if (k == 0) {
            return DoubleMatrix.identity((int)size);
        }
        if (k > 2) {
            throw new UnsupportedOperationException("cannot handle order (k) > 2");
        }
        ArgChecker.isTrue((size > 2 ? 1 : 0) != 0, (String)"Need at least 3 points for a three point estimate");
        double[] dx = new double[size - 1];
        double[] dx2 = new double[size - 1];
        for (int i = 0; i < size - 1; ++i) {
            double temp = x[i + 1] - x[i];
            ArgChecker.isTrue((temp > 0.0 ? 1 : 0) != 0, (String)"x not in ascending order, or two identical points");
            dx[i] = temp;
            dx2[i] = temp * temp;
        }
        double[] w = new double[size - 2];
        for (int i = 0; i < size - 2; ++i) {
            w[i] = 1.0 / (dx[i] * dx[i + 1] * (dx[i] + dx[i + 1]));
        }
        double[][] data = new double[size][size];
        if (k == 1) {
            for (int i = 1; i < size - 1; ++i) {
                data[i][i - 1] = -w[i - 1] * dx2[i];
                data[i][i] = w[i - 1] * (dx2[i] - dx2[i - 1]);
                data[i][i + 1] = w[i - 1] * dx2[i - 1];
            }
            if (includeEnds) {
                data[0][0] = -w[0] * dx[1] * (2.0 * dx[0] + dx[1]);
                data[0][1] = w[0] * (dx2[0] + dx2[1] + 2.0 * dx[0] * dx[1]);
                data[0][2] = -w[0] * dx2[0];
                data[size - 1][size - 3] = w[size - 3] * dx2[size - 2];
                data[size - 1][size - 2] = -w[size - 3] * (dx2[size - 3] + dx2[size - 2] + 2.0 * dx[size - 2] * dx[size - 3]);
                data[size - 1][size - 1] = w[size - 3] * dx[size - 3] * (2.0 * dx[size - 2] + dx[size - 3]);
            }
        } else {
            for (int i = 1; i < size - 1; ++i) {
                double tmp = 2.0 * w[i - 1];
                data[i][i - 1] = tmp * dx[i];
                data[i][i] = -tmp * (dx[i] + dx[i - 1]);
                data[i][i + 1] = tmp * dx[i - 1];
            }
            if (includeEnds) {
                data[0] = data[1];
                data[size - 1] = data[size - 2];
            }
        }
        return DoubleMatrix.copyOf((double[][])data);
    }

    public static DoubleMatrix getPenaltyMatrix(double[] x, int k) {
        ArgChecker.notEmpty((double[])x, (String)"x");
        if (x.length == 1) {
            if (k == 0) {
                return DoubleMatrix.identity((int)1);
            }
            throw new IllegalArgumentException("order too high. Length of x is 1 and k is " + k);
        }
        double range = x[x.length - 1] - x[0];
        ArgChecker.notNegativeOrZero((double)range, (String)"range of x");
        double scale = Math.pow(range, k);
        DoubleMatrix d = (DoubleMatrix)MA.scale((Matrix)PenaltyMatrixGenerator.getDerivativeMatrix(x, k, false), scale);
        DoubleMatrix dt = MA.getTranspose((Matrix)d);
        return (DoubleMatrix)MA.multiply((Matrix)dt, (Matrix)d);
    }

    public static DoubleMatrix getPenaltyMatrix(double[][] x, int k, int index) {
        ArgChecker.noNulls((Object[])x, (String)"x");
        int dim = x.length;
        int[] numElements = new int[dim];
        for (int i = 0; i < dim; ++i) {
            numElements[i] = x[i].length;
        }
        DoubleMatrix p = PenaltyMatrixGenerator.getPenaltyMatrix(x[index], k);
        return PenaltyMatrixGenerator.getMatrixForFlattened(numElements, p, index);
    }

    public static DoubleMatrix getPenaltyMatrix(double[][] x, int[] k, double[] lambda) {
        ArgChecker.notEmpty((int[])k, (String)"k");
        ArgChecker.notEmpty((double[])lambda, (String)"lambda");
        int dim = x.length;
        ArgChecker.isTrue((dim == k.length ? 1 : 0) != 0, (String)"k different lenght to size");
        ArgChecker.isTrue((dim == lambda.length ? 1 : 0) != 0, (String)"lambda different length to size");
        DoubleMatrix p = (DoubleMatrix)MA.scale((Matrix)PenaltyMatrixGenerator.getPenaltyMatrix(x, k[0], 0), lambda[0]);
        for (int i = 1; i < dim; ++i) {
            DoubleMatrix temp = (DoubleMatrix)MA.scale((Matrix)PenaltyMatrixGenerator.getPenaltyMatrix(x, k[i], i), lambda[i]);
            p = (DoubleMatrix)MA.add((Matrix)p, (Matrix)temp);
        }
        return p;
    }

    public static DoubleArray flattenMatrix(DoubleMatrix aMatrix) {
        int elements = aMatrix.size();
        double[] data = new double[elements];
        int nRows = aMatrix.rowCount();
        int nCols = aMatrix.columnCount();
        int pos = 0;
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(aMatrix.rowArray(i), 0, data, pos, nCols);
            pos += nCols;
        }
        return DoubleArray.copyOf((double[])data);
    }

    public static DoubleMatrix getMatrixForFlattened(int[] numElements, DoubleMatrix m, int index) {
        int j;
        ArgChecker.notEmpty((int[])numElements, (String)"numElements");
        int dim = numElements.length;
        ArgChecker.notNull((Object)m, (String)"m");
        ArgChecker.isTrue((index >= 0 && index < dim ? 1 : 0) != 0, (String)"indices outside range");
        ArgChecker.isTrue((m.columnCount() == numElements[index] ? 1 : 0) != 0, (String)"columns in m ({}) do not match numElements for index ({})", (Object[])new Object[]{m.columnCount(), numElements[index]});
        int postProduct = 1;
        int preProduct = 1;
        for (j = index + 1; j < dim; ++j) {
            preProduct *= numElements[j];
        }
        for (j = 0; j < index; ++j) {
            postProduct *= numElements[j];
        }
        DoubleMatrix temp = m;
        if (preProduct != 1) {
            temp = (DoubleMatrix)MA.kroneckerProduct((Matrix)temp, (Matrix)DoubleMatrix.identity((int)preProduct));
        }
        if (postProduct != 1) {
            temp = (DoubleMatrix)MA.kroneckerProduct((Matrix)DoubleMatrix.identity((int)postProduct), (Matrix)temp);
        }
        return temp;
    }
}

