/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.PiecewiseCubicHermiteSplineInterpolatorWithSensitivity;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;
import java.util.stream.IntStream;

public class PiecewiseCubicHermiteSplineInterpolator
extends PiecewisePolynomialInterpolator {
    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"xValues length = yValues length");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be more than 1");
        int nDataPts = xValues.length;
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xData containing Infinity");
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yData containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yData containing Infinity");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[] yValuesSrt = Arrays.copyOf(yValues, nDataPts);
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix coefMatrix = this.solve(xValuesSrt, yValuesSrt);
        for (int i = 0; i < coefMatrix.rowCount(); ++i) {
            for (int j = 0; j < coefMatrix.columnCount(); ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix.get(i, j)), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix.get(i, j)), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), coefMatrix, coefMatrix.columnCount(), 1);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        int j;
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValuesMatrix, (String)"yValuesMatrix");
        ArgChecker.isTrue((xValues.length == yValuesMatrix[0].length ? 1 : 0) != 0, (String)"(xValues length = yValuesMatrix's row vector length)");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be more than 1");
        int nDataPts = xValues.length;
        int dim = yValuesMatrix.length;
        for (int i2 = 0; i2 < nDataPts; ++i2) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i2]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i2]), (String)"xValues containing Infinity");
            for (int j2 = 0; j2 < dim; ++j2) {
                ArgChecker.isFalse((boolean)Double.isNaN(yValuesMatrix[j2][i2]), (String)"yValuesMatrix containing NaN");
                ArgChecker.isFalse((boolean)Double.isInfinite(yValuesMatrix[j2][i2]), (String)"yValuesMatrix containing Infinity");
            }
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        int[] sortedPositions = IntStream.range(0, nDataPts).toArray();
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (int[])sortedPositions);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        for (int i3 = 0; i3 < dim; ++i3) {
            double[] yValuesSrt = DoubleArrayMath.reorderedCopy((double[])yValuesMatrix[i3], (int[])sortedPositions);
            coefMatrix[i3] = this.solve(xValuesSrt, yValuesSrt);
        }
        int nIntervals = coefMatrix[0].rowCount();
        int nCoefs = coefMatrix[0].columnCount();
        double[][] resMatrix = new double[dim * nIntervals][nCoefs];
        for (i = 0; i < nIntervals; ++i) {
            for (j = 0; j < dim; ++j) {
                resMatrix[dim * i + j] = coefMatrix[j].row(i).toArray();
            }
        }
        for (i = 0; i < nIntervals * dim; ++i) {
            for (j = 0; j < nCoefs; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(resMatrix[i][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(resMatrix[i][j]), (String)"Too large input");
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])resMatrix), nCoefs, dim);
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        PiecewiseCubicHermiteSplineInterpolatorWithSensitivity interp = new PiecewiseCubicHermiteSplineInterpolatorWithSensitivity();
        return interp.interpolateWithSensitivity(xValues, yValues);
    }

    private DoubleMatrix solve(double[] xValues, double[] yValues) {
        int nDataPts = xValues.length;
        double[][] res = new double[nDataPts - 1][4];
        double[] intervals = new double[nDataPts - 1];
        double[] grads = new double[nDataPts - 1];
        for (int i = 0; i < nDataPts - 1; ++i) {
            intervals[i] = xValues[i + 1] - xValues[i];
            grads[i] = (yValues[i + 1] - yValues[i]) / intervals[i];
        }
        if (nDataPts == 2) {
            res[0][2] = grads[0];
            res[0][3] = yValues[0];
        } else {
            double[] derivatives = this.slopeFinder(intervals, grads);
            for (int i = 0; i < nDataPts - 1; ++i) {
                res[i][0] = (derivatives[i] - 2.0 * grads[i] + derivatives[i + 1]) / intervals[i] / intervals[i];
                res[i][1] = (3.0 * grads[i] - 2.0 * derivatives[i] - derivatives[i + 1]) / intervals[i];
                res[i][2] = derivatives[i];
                res[i][3] = yValues[i];
            }
        }
        return DoubleMatrix.copyOf((double[][])res);
    }

    private double[] slopeFinder(double[] intervals, double[] grads) {
        int nInts = intervals.length;
        double[] res = new double[nInts + 1];
        res[0] = this.endpointSlope(intervals[0], intervals[1], grads[0], grads[1]);
        res[nInts] = this.endpointSlope(intervals[nInts - 1], intervals[nInts - 2], grads[nInts - 1], grads[nInts - 2]);
        for (int i = 1; i < nInts; ++i) {
            if (grads[i] * grads[i - 1] <= 0.0) {
                res[i] = 0.0;
                continue;
            }
            double den1 = 2.0 * intervals[i] + intervals[i - 1];
            double den2 = intervals[i] + 2.0 * intervals[i - 1];
            res[i] = (den1 + den2) / (den1 / grads[i - 1] + den2 / grads[i]);
        }
        return res;
    }

    private double endpointSlope(double ints1, double ints2, double grads1, double grads2) {
        double val = ((2.0 * ints1 + ints2) * grads1 - ints1 * grads2) / (ints1 + ints2);
        if (Math.signum(val) != Math.signum(grads1)) {
            return 0.0;
        }
        if (Math.signum(grads1) != Math.signum(grads2) && Math.abs(val) > 3.0 * Math.abs(grads1)) {
            return 3.0 * grads1;
        }
        return val;
    }
}

