/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.MathUtils;
import com.opengamma.strata.math.impl.interpolation.PiecewiseCubicHermiteSplineInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;

public class PiecewiseCubicHermiteSplineInterpolatorWithSensitivity
extends PiecewisePolynomialInterpolator {
    private static final PiecewiseCubicHermiteSplineInterpolator INTERP = new PiecewiseCubicHermiteSplineInterpolator();

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"xValues length = yValues length");
        ArgChecker.isTrue((xValues.length > 1 ? 1 : 0) != 0, (String)"Data points should be more than 1");
        int nDataPts = xValues.length;
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isTrue((boolean)Double.isFinite(xValues[i]), (String)"xData is not finite");
            ArgChecker.isTrue((boolean)Double.isFinite(yValues[i]), (String)"yData is not finite");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[] yValuesSrt = Arrays.copyOf(yValues, nDataPts);
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix[] temp = this.solve(xValuesSrt, yValuesSrt);
        int n = temp.length;
        for (int k = 0; k < n; ++k) {
            DoubleMatrix m = temp[k];
            int rows = m.rowCount();
            int cols = m.columnCount();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    ArgChecker.isTrue((boolean)Doubles.isFinite((double)m.get(i, j)), (String)"Matrix contains a NaN or infinite");
                }
            }
        }
        DoubleMatrix coefMatrix = temp[0];
        DoubleMatrix[] coefMatrixSense = new DoubleMatrix[n - 1];
        System.arraycopy(temp, 1, coefMatrixSense, 0, n - 1);
        return new PiecewisePolynomialResultsWithSensitivity(DoubleArray.copyOf((double[])xValuesSrt), coefMatrix, 4, 1, coefMatrixSense);
    }

    private DoubleMatrix[] solve(double[] xValues, double[] yValues) {
        int n = xValues.length;
        double[][] coeff = new double[n - 1][4];
        double[] h = new double[n - 1];
        double[] delta = new double[n - 1];
        DoubleMatrix[] res = new DoubleMatrix[n];
        for (int i = 0; i < n - 1; ++i) {
            h[i] = xValues[i + 1] - xValues[i];
            delta[i] = (yValues[i + 1] - yValues[i]) / h[i];
        }
        if (n == 2) {
            coeff[0][2] = delta[0];
            coeff[0][3] = yValues[0];
            double[][] coeffSense = new double[4][2];
            coeffSense[2][1] = 1.0 / h[0];
            coeffSense[2][0] = -1.0 / h[0];
            coeffSense[3][0] = 1.0;
            res[1] = DoubleMatrix.copyOf((double[][])coeffSense);
        } else {
            SlopeFinderResults temp = this.slopeFinder(h, delta, yValues);
            DoubleArray d = temp.getSlopes();
            double[][] dDy = temp.getSlopeJacobian().toArray();
            for (int i = 0; i < n - 1; ++i) {
                coeff[i][0] = (d.get(i) - 2.0 * delta[i] + d.get(i + 1)) / h[i] / h[i];
                coeff[i][1] = (3.0 * delta[i] - 2.0 * d.get(i) - d.get(i + 1)) / h[i];
                coeff[i][2] = d.get(i);
                coeff[i][3] = yValues[i];
            }
            double[][] bDy = new double[n - 1][n];
            double[][] cDy = new double[n - 1][n];
            for (int i = 0; i < n - 1; ++i) {
                double invH = 1.0 / h[i];
                double invH2 = invH * invH;
                double invH3 = invH * invH2;
                cDy[i][i] = -3.0 * invH2;
                cDy[i][i + 1] = 3.0 * invH2;
                bDy[i][i] = 2.0 * invH3;
                bDy[i][i + 1] = -2.0 * invH3;
                for (int j = 0; j < n; ++j) {
                    double[] dArray = cDy[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - (2.0 * dDy[i][j] + dDy[i + 1][j]) * invH;
                    double[] dArray2 = bDy[i];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] + (dDy[i][j] + dDy[i + 1][j]) * invH2;
                }
            }
            for (int k = 0; k < n - 1; ++k) {
                double[][] coeffSense = new double[][]{bDy[k], cDy[k], dDy[k], new double[n]};
                coeffSense[3][k] = 1.0;
                res[k + 1] = DoubleMatrix.copyOf((double[][])coeffSense);
            }
        }
        res[0] = DoubleMatrix.copyOf((double[][])coeff);
        return res;
    }

    private SlopeFinderResults slopeFinder(double[] h, double[] delta, double[] y) {
        int i;
        int n = y.length;
        double[] invDelta = new double[n - 1];
        double[] invDelta2 = new double[n - 1];
        double[] invH = new double[n - 1];
        for (int i2 = 0; i2 < n - 1; ++i2) {
            invDelta[i2] = 1.0 / delta[i2];
            invDelta2[i2] = invDelta[i2] * invDelta[i2];
            invH[i2] = 1.0 / h[i2];
        }
        double[] d = new double[n];
        double[][] jac = new double[n][n];
        for (int i3 = 1; i3 < n - 1; ++i3) {
            double w12;
            double w2;
            double w1;
            if (delta[i3] * delta[i3 - 1] > 0.0) {
                w1 = 2.0 * h[i3] + h[i3 - 1];
                w2 = h[i3] + 2.0 * h[i3 - 1];
                w12 = w1 + w2;
                d[i3] = w12 / (w1 * invDelta[i3 - 1] + w2 * invDelta[i3]);
                double z1 = d[i3] * d[i3] / w12;
                jac[i3][i3 - 1] = -w1 * invH[i3 - 1] * invDelta2[i3 - 1] * z1;
                jac[i3][i3] = (w1 * invH[i3 - 1] * invDelta2[i3 - 1] - w2 * invH[i3] * invDelta2[i3]) * z1;
                jac[i3][i3 + 1] = w2 * invH[i3] * invDelta2[i3] * z1;
                continue;
            }
            if (!(delta[i3] == 0.0 ^ delta[i3 - 1] == 0.0)) continue;
            w1 = 2.0 * h[i3] + h[i3 - 1];
            w2 = h[i3] + 2.0 * h[i3 - 1];
            w12 = w1 + w2;
            double z2 = 0.5 * w12 / MathUtils.pow2(w1 * delta[i3] + w2 * delta[i3 - 1]);
            jac[i3][i3 - 1] = -w1 * invH[i3 - 1] * delta[i3] * delta[i3] * z2;
            jac[i3][i3] = (w1 * invH[i3 - 1] * delta[i3] * delta[i3] - w2 * invH[i3] * delta[i3 - 1] * delta[i3 - 1]) * z2;
            jac[i3][i3 + 1] = w2 * invH[i3] * delta[i3 - 1] * delta[i3 - 1] * z2;
        }
        double[] temp = this.endpointSlope(h[0], h[1], delta[0], delta[1], false);
        d[0] = temp[0];
        for (i = 0; i < 3; ++i) {
            jac[0][i] = temp[i + 1];
        }
        temp = this.endpointSlope(h[n - 2], h[n - 3], delta[n - 2], delta[n - 3], true);
        d[n - 1] = temp[0];
        for (i = 1; i < 4; ++i) {
            jac[n - 1][n - i] = temp[i];
        }
        return new SlopeFinderResults(DoubleArray.copyOf((double[])d), DoubleMatrix.copyOf((double[][])jac));
    }

    private double[] endpointSlope(double h1, double h2, double del1, double del2, boolean rightSide) {
        double[] res = new double[4];
        if (del1 == 0.0) {
            if (del2 == 0.0) {
                res[1] = -(2.0 * h1 + h2) / h1 / (h1 + h2);
                res[2] = h1 > 2.0 * h2 ? 3.0 / h1 : (h1 + h2) / h1 / h2;
            } else {
                res[1] = -1.5 / h1;
                res[2] = -res[1];
            }
            if (rightSide) {
                res[1] = -res[1];
                res[2] = -res[2];
            }
            return res;
        }
        double d = ((2.0 * h1 + h2) * del1 - h1 * del2) / (h1 + h2);
        if (Math.signum(d) != Math.signum(del1)) {
            if (Math.abs(d) < 1.0E-15) {
                res[1] = -(2.0 * h1 + h2) / h1 / (h1 + h2);
                res[2] = (h1 + h2) / h1 / h2;
                res[3] = -h1 / h2 / (h1 + h2);
            }
        } else if (Math.signum(del1) != Math.signum(del2) && Math.abs(d) > 3.0 * Math.abs(del1)) {
            res[0] = 3.0 * del1;
            res[1] = -3.0 / h1;
            res[2] = -res[1];
        } else {
            res[0] = d;
            res[1] = -(2.0 * h1 + h2) / h1 / (h1 + h2);
            res[2] = (h1 + h2) / h1 / h2;
            res[3] = -h1 / h2 / (h1 + h2);
        }
        if (rightSide) {
            for (int i = 1; i < 4; ++i) {
                res[i] = -res[i];
            }
        }
        return res;
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        return INTERP.interpolate(xValues, yValues);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        return INTERP.interpolate(xValues, yValuesMatrix);
    }

    private class SlopeFinderResults {
        private final DoubleArray _d;
        private final DoubleMatrix _dDy;

        public SlopeFinderResults(DoubleArray d, DoubleMatrix dDy) {
            this._d = d;
            this._dDy = dDy;
        }

        public DoubleArray getSlopes() {
            return this._d;
        }

        public DoubleMatrix getSlopeJacobian() {
            return this._dDy;
        }
    }
}

