/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;

public abstract class PiecewisePolynomialInterpolator {
    public abstract PiecewisePolynomialResult interpolate(double[] var1, double[] var2);

    public abstract PiecewisePolynomialResult interpolate(double[] var1, double[][] var2);

    public double interpolate(double[] xValues, double[] yValues, double xKey) {
        ArgChecker.isFalse((boolean)Double.isNaN(xKey), (String)"xKey containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(xKey), (String)"xKey containing Infinity");
        PiecewisePolynomialResult result = this.interpolate(xValues, yValues);
        DoubleArray knots = result.getKnots();
        int nKnots = knots.size();
        DoubleMatrix coefMatrix = result.getCoefMatrix();
        double res = 0.0;
        int indicator = 0;
        if (xKey < knots.get(1)) {
            indicator = 0;
        } else {
            for (int i = 1; i < nKnots - 1; ++i) {
                if (!(knots.get(i) <= xKey)) continue;
                indicator = i;
            }
        }
        DoubleArray coefs = coefMatrix.row(indicator);
        res = this.getValue(coefs, xKey, knots.get(indicator));
        ArgChecker.isFalse((boolean)Double.isInfinite(res), (String)"Too large input");
        ArgChecker.isFalse((boolean)Double.isNaN(res), (String)"Too large input");
        return res;
    }

    public DoubleArray interpolate(double[] xValues, double[] yValues, double[] xKeys) {
        ArgChecker.notNull((Object)xKeys, (String)"xKeys");
        int keyLength = xKeys.length;
        for (int i = 0; i < keyLength; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xKeys[i]), (String)"xKeys containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xKeys[i]), (String)"xKeys containing Infinity");
        }
        PiecewisePolynomialResult result = this.interpolate(xValues, yValues);
        DoubleArray knots = result.getKnots();
        int nKnots = knots.size();
        DoubleMatrix coefMatrix = result.getCoefMatrix();
        double[] res = new double[keyLength];
        for (int j = 0; j < keyLength; ++j) {
            int indicator = 0;
            if (xKeys[j] < knots.get(1)) {
                indicator = 0;
            } else {
                for (int i = 1; i < nKnots - 1; ++i) {
                    if (!(knots.get(i) <= xKeys[j])) continue;
                    indicator = i;
                }
            }
            DoubleArray coefs = coefMatrix.row(indicator);
            res[j] = this.getValue(coefs, xKeys[j], knots.get(indicator));
            ArgChecker.isFalse((boolean)Double.isInfinite(res[j]), (String)"Too large input");
            ArgChecker.isFalse((boolean)Double.isNaN(res[j]), (String)"Too large input");
        }
        return DoubleArray.copyOf((double[])res);
    }

    public DoubleMatrix interpolate(double[] xValues, double[] yValues, double[][] xMatrix) {
        ArgChecker.notNull((Object)xMatrix, (String)"xMatrix");
        DoubleMatrix matrix = DoubleMatrix.copyOf((double[][])xMatrix);
        return DoubleMatrix.ofArrayObjects((int)xMatrix.length, (int)xMatrix[0].length, i -> this.interpolate(xValues, yValues, matrix.rowArray(i)));
    }

    public DoubleArray interpolate(double[] xValues, double[][] yValuesMatrix, double x) {
        DoubleMatrix matrix = DoubleMatrix.copyOf((double[][])yValuesMatrix);
        return DoubleArray.of((int)matrix.rowCount(), i -> this.interpolate(xValues, matrix.rowArray(i), x));
    }

    public DoubleMatrix interpolate(double[] xValues, double[][] yValuesMatrix, double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        DoubleMatrix matrix = DoubleMatrix.copyOf((double[][])yValuesMatrix);
        return DoubleMatrix.ofArrayObjects((int)yValuesMatrix.length, (int)x.length, i -> this.interpolate(xValues, matrix.rowArray(i), x));
    }

    public DoubleMatrix[] interpolate(double[] xValues, double[][] yValuesMatrix, double[][] xMatrix) {
        ArgChecker.notNull((Object)xMatrix, (String)"xMatrix");
        int keyColumn = xMatrix[0].length;
        DoubleMatrix matrix = DoubleMatrix.copyOf((double[][])xMatrix);
        DoubleMatrix[] resMatrix2D = new DoubleMatrix[keyColumn];
        for (int i = 0; i < keyColumn; ++i) {
            resMatrix2D[i] = this.interpolate(xValues, yValuesMatrix, matrix.columnArray(i));
        }
        return resMatrix2D;
    }

    public abstract PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] var1, double[] var2);

    public PiecewisePolynomialInterpolator getPrimaryMethod() {
        return this;
    }

    protected double getValue(DoubleArray coefs, double x, double leftknot) {
        return this.getValue(coefs.toArrayUnsafe(), x, leftknot);
    }

    protected double getValue(double[] coefs, double x, double leftknot) {
        int nCoefs = coefs.length;
        double s = x - leftknot;
        double res = coefs[0];
        for (int i = 1; i < nCoefs; ++i) {
            res *= s;
            res += coefs[i];
        }
        return res;
    }
}

