/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult2D;

public abstract class PiecewisePolynomialInterpolator2D {
    public abstract PiecewisePolynomialResult2D interpolate(double[] var1, double[] var2, double[][] var3);

    public DoubleMatrix interpolate(double[] x0Values, double[] x1Values, double[][] yValues, double[] x0Keys, double[] x1Keys) {
        int i;
        ArgChecker.notNull((Object)x0Keys, (String)"x0Keys");
        ArgChecker.notNull((Object)x1Keys, (String)"x1Keys");
        int n0Keys = x0Keys.length;
        int n1Keys = x1Keys.length;
        for (i = 0; i < n0Keys; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(x0Keys[i]), (String)"x0Keys containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(x0Keys[i]), (String)"x0Keys containing Infinity");
        }
        for (i = 0; i < n1Keys; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(x1Keys[i]), (String)"x1Keys containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(x1Keys[i]), (String)"x1Keys containing Infinity");
        }
        PiecewisePolynomialResult2D result = this.interpolate(x0Values, x1Values, yValues);
        DoubleArray knots0 = result.getKnots0();
        DoubleArray knots1 = result.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        double[][] res = new double[n0Keys][n1Keys];
        for (int i2 = 0; i2 < n0Keys; ++i2) {
            for (int j = 0; j < n1Keys; ++j) {
                int k;
                int ind0 = 0;
                int ind1 = 0;
                for (k = 1; k < nKnots0 - 1; ++k) {
                    if (!(x0Keys[i2] >= knots0.get(k))) continue;
                    ind0 = k;
                }
                for (k = 1; k < nKnots1 - 1; ++k) {
                    if (!(x1Keys[j] >= knots1.get(k))) continue;
                    ind1 = k;
                }
                res[i2][j] = this.getValue(result.getCoefs()[ind0][ind1], x0Keys[i2], x1Keys[j], knots0.get(ind0), knots1.get(ind1));
                ArgChecker.isFalse((boolean)Double.isInfinite(res[i2][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isNaN(res[i2][j]), (String)"Too large input");
            }
        }
        return DoubleMatrix.copyOf((double[][])res);
    }

    public double interpolate(double[] x0Values, double[] x1Values, double[][] yValues, double x0Key, double x1Key) {
        PiecewisePolynomialResult2D result = this.interpolate(x0Values, x1Values, yValues);
        ArgChecker.isFalse((boolean)Double.isNaN(x0Key), (String)"x0Key containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(x0Key), (String)"x0Key containing Infinity");
        ArgChecker.isFalse((boolean)Double.isNaN(x1Key), (String)"x1Key containing NaN");
        ArgChecker.isFalse((boolean)Double.isInfinite(x1Key), (String)"x1Key containing Infinity");
        DoubleArray knots0 = result.getKnots0();
        DoubleArray knots1 = result.getKnots1();
        int nKnots0 = knots0.size();
        int nKnots1 = knots1.size();
        int ind0 = 0;
        int ind1 = 0;
        for (int k = 1; k < nKnots0 - 1; ++k) {
            if (!(x0Key >= knots0.get(k))) continue;
            ind0 = k;
        }
        for (int i = 1; i < nKnots1 - 1; ++i) {
            if (!(x1Key >= knots1.get(i))) continue;
            ind1 = i;
        }
        double res = this.getValue(result.getCoefs()[ind0][ind1], x0Key, x1Key, knots0.get(ind0), knots1.get(ind1));
        ArgChecker.isFalse((boolean)Double.isInfinite(res), (String)"Too large input");
        ArgChecker.isFalse((boolean)Double.isNaN(res), (String)"Too large input");
        return res;
    }

    protected double getValue(DoubleMatrix coefMat, double x0, double x1, double leftKnot0, double leftKnot1) {
        int order0 = coefMat.rowCount();
        int order1 = coefMat.columnCount();
        double x0Mod = x0 - leftKnot0;
        double x1Mod = x1 - leftKnot1;
        double res = 0.0;
        for (int i = 0; i < order0; ++i) {
            for (int j = 0; j < order1; ++j) {
                res += coefMat.get(order0 - i - 1, order1 - j - 1) * Math.pow(x0Mod, i) * Math.pow(x1Mod, j);
            }
        }
        return res;
    }
}

