/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import java.util.ArrayList;

public class PiecewisePolynomialResult2D {
    private final DoubleArray _knots0;
    private final DoubleArray _knots1;
    private final DoubleMatrix[][] _coefMatrix;
    private final int[] _nIntervals;
    private final int[] _order;

    public PiecewisePolynomialResult2D(DoubleArray knots0, DoubleArray knots1, DoubleMatrix[][] coefMatrix, int[] order) {
        this._knots0 = knots0;
        this._knots1 = knots1;
        this._coefMatrix = coefMatrix;
        this._nIntervals = new int[2];
        this._nIntervals[0] = knots0.size() - 1;
        this._nIntervals[1] = knots1.size() - 1;
        this._order = order;
    }

    public ArrayList<DoubleArray> getKnots2D() {
        ArrayList<DoubleArray> res = new ArrayList<DoubleArray>();
        res.add(this._knots0);
        res.add(this._knots1);
        return res;
    }

    public DoubleArray getKnots0() {
        return this._knots0;
    }

    public DoubleArray getKnots1() {
        return this._knots1;
    }

    public DoubleMatrix[][] getCoefs() {
        return this._coefMatrix;
    }

    public int[] getNumberOfIntervals() {
        return this._nIntervals;
    }

    public int[] getOrder() {
        return this._order;
    }
}

