/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import java.util.Arrays;

public class PiecewisePolynomialResultsWithSensitivity
extends PiecewisePolynomialResult {
    private final DoubleMatrix[] _coeffSense;

    public PiecewisePolynomialResultsWithSensitivity(DoubleArray knots, DoubleMatrix coefMatrix, int order, int dim, DoubleMatrix[] coeffSense) {
        super(knots, coefMatrix, order, dim);
        if (dim != 1) {
            throw new UnsupportedOperationException();
        }
        ArgChecker.noNulls((Object[])coeffSense, (String)"null coeffSense");
        this._coeffSense = coeffSense;
    }

    public DoubleMatrix[] getCoefficientSensitivityAll() {
        return this._coeffSense;
    }

    public DoubleMatrix getCoefficientSensitivity(int interval) {
        return this._coeffSense[interval];
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this._coeffSense);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PiecewisePolynomialResultsWithSensitivity)) {
            return false;
        }
        PiecewisePolynomialResultsWithSensitivity other = (PiecewisePolynomialResultsWithSensitivity)obj;
        return Arrays.equals(this._coeffSense, other._coeffSense);
    }
}

