/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.function.PiecewisePolynomialWithSensitivityFunction1D;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;

public class ProductPiecewisePolynomialInterpolator
extends PiecewisePolynomialInterpolator {
    private final PiecewisePolynomialInterpolator _baseMethod;
    private final double[] _xValuesClamped;
    private final double[] _yValuesClamped;
    private final boolean _isClamped;
    private static final PiecewisePolynomialWithSensitivityFunction1D FUNC = new PiecewisePolynomialWithSensitivityFunction1D();
    private static final double EPS = 1.0E-15;

    public ProductPiecewisePolynomialInterpolator(PiecewisePolynomialInterpolator baseMethod) {
        ArgChecker.notNull((Object)baseMethod, (String)"baseMethod");
        ArgChecker.isFalse((boolean)(baseMethod instanceof ProductPiecewisePolynomialInterpolator), (String)"baseMethod should not be ProductPiecewisePolynomialInterpolator");
        this._baseMethod = baseMethod;
        this._xValuesClamped = null;
        this._yValuesClamped = null;
        this._isClamped = false;
    }

    public ProductPiecewisePolynomialInterpolator(PiecewisePolynomialInterpolator baseMethod, double[] xValuesClamped, double[] yValuesClamped) {
        ArgChecker.notNull((Object)baseMethod, (String)"method");
        ArgChecker.notNull((Object)xValuesClamped, (String)"xValuesClamped");
        ArgChecker.notNull((Object)yValuesClamped, (String)"yValuesClamped");
        ArgChecker.isFalse((boolean)(baseMethod instanceof ProductPiecewisePolynomialInterpolator), (String)"baseMethod should not be ProductPiecewisePolynomialInterpolator");
        int nExtraPoints = xValuesClamped.length;
        ArgChecker.isTrue((yValuesClamped.length == nExtraPoints ? 1 : 0) != 0, (String)"xValuesClamped and yValuesClamped should be the same length");
        this._baseMethod = baseMethod;
        this._xValuesClamped = Arrays.copyOf(xValuesClamped, nExtraPoints);
        this._yValuesClamped = Arrays.copyOf(yValuesClamped, nExtraPoints);
        this._isClamped = true;
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        PiecewisePolynomialResult result;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"xValues length = yValues length");
        if (this._isClamped) {
            double[][] xyValuesAll = this.getDataTotal(xValues, yValues);
            result = this._baseMethod.interpolate(xyValuesAll[0], xyValuesAll[1]);
        } else {
            double[] xyValues = this.getProduct(xValues, yValues);
            result = this._baseMethod.interpolate(xValues, xyValues);
        }
        return this.extrapolateByLinearFunction(result, xValues);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        throw new UnsupportedOperationException("Use 1D interpolation method");
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        PiecewisePolynomialResultsWithSensitivity result;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"xValues length = yValues length");
        if (this._isClamped) {
            double[][] xyValuesAll = this.getDataTotal(xValues, yValues);
            result = this._baseMethod.interpolateWithSensitivity(xyValuesAll[0], xyValuesAll[1]);
        } else {
            double[] xyValues = this.getProduct(xValues, yValues);
            result = this._baseMethod.interpolateWithSensitivity(xValues, xyValues);
        }
        return (PiecewisePolynomialResultsWithSensitivity)this.extrapolateByLinearFunction(result, xValues);
    }

    private PiecewisePolynomialResult extrapolateByLinearFunction(PiecewisePolynomialResult result, double[] xValues) {
        int nIntervalsAll = result.getNumberOfIntervals();
        double[] nodes = result.getKnots().toArray();
        if (Math.abs(xValues[xValues.length - 1] - nodes[nIntervalsAll]) < 1.0E-15) {
            double lastNodeX = nodes[nIntervalsAll];
            double lastNodeY = FUNC.evaluate(result, lastNodeX).get(0);
            double extraNode = 2.0 * nodes[nIntervalsAll] - nodes[nIntervalsAll - 1];
            double extraDerivative = FUNC.differentiate(result, lastNodeX).get(0);
            double[] newKnots = new double[nIntervalsAll + 2];
            System.arraycopy(nodes, 0, newKnots, 0, nIntervalsAll + 1);
            newKnots[nIntervalsAll + 1] = extraNode;
            double[][] newCoefMatrix = new double[nIntervalsAll + 1][];
            for (int i = 0; i < nIntervalsAll; ++i) {
                newCoefMatrix[i] = Arrays.copyOf(result.getCoefMatrix().row(i).toArray(), result.getOrder());
            }
            newCoefMatrix[nIntervalsAll] = new double[result.getOrder()];
            newCoefMatrix[nIntervalsAll][result.getOrder() - 1] = lastNodeY;
            newCoefMatrix[nIntervalsAll][result.getOrder() - 2] = extraDerivative;
            if (result instanceof PiecewisePolynomialResultsWithSensitivity) {
                PiecewisePolynomialResultsWithSensitivity resultCast = (PiecewisePolynomialResultsWithSensitivity)result;
                double[] extraSense = FUNC.nodeSensitivity(resultCast, lastNodeX).toArray();
                double[] extraSenseDer = FUNC.differentiateNodeSensitivity(resultCast, lastNodeX).toArray();
                DoubleMatrix[] newCoefSense = new DoubleMatrix[nIntervalsAll + 1];
                for (int i = 0; i < nIntervalsAll; ++i) {
                    newCoefSense[i] = resultCast.getCoefficientSensitivity(i);
                }
                double[][] extraCoefSense = new double[resultCast.getOrder()][extraSense.length];
                extraCoefSense[resultCast.getOrder() - 1] = Arrays.copyOf(extraSense, extraSense.length);
                extraCoefSense[resultCast.getOrder() - 2] = Arrays.copyOf(extraSenseDer, extraSenseDer.length);
                newCoefSense[nIntervalsAll] = DoubleMatrix.copyOf((double[][])extraCoefSense);
                return new PiecewisePolynomialResultsWithSensitivity(DoubleArray.copyOf((double[])newKnots), DoubleMatrix.copyOf((double[][])newCoefMatrix), resultCast.getOrder(), 1, newCoefSense);
            }
            return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])newKnots), DoubleMatrix.copyOf((double[][])newCoefMatrix), result.getOrder(), 1);
        }
        return result;
    }

    @Override
    public PiecewisePolynomialInterpolator getPrimaryMethod() {
        return this._baseMethod;
    }

    private double[][] getDataTotal(double[] xData, double[] yData) {
        int nExtraPoints = this._xValuesClamped.length;
        int nData = xData.length;
        int nTotal = nExtraPoints + nData;
        double[] xValuesTotal = new double[nTotal];
        double[] yValuesTotal = new double[nTotal];
        System.arraycopy(xData, 0, xValuesTotal, 0, nData);
        System.arraycopy(yData, 0, yValuesTotal, 0, nData);
        System.arraycopy(this._xValuesClamped, 0, xValuesTotal, nData, nExtraPoints);
        System.arraycopy(this._yValuesClamped, 0, yValuesTotal, nData, nExtraPoints);
        DoubleArrayMath.sortPairs((double[])xValuesTotal, (double[])yValuesTotal);
        double[] xyTotal = this.getProduct(xValuesTotal, yValuesTotal);
        return new double[][]{xValuesTotal, xyTotal};
    }

    private double[] getProduct(double[] x, double[] y) {
        int n = x.length;
        double[] xy = new double[n];
        for (int i = 0; i < n; ++i) {
            xy[i] = x[i] * y[i];
        }
        return xy;
    }
}

