/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.interpolation.HermiteCoefficientsProvider;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.util.Arrays;
import java.util.stream.IntStream;

public class SemiLocalCubicSplineInterpolator
extends PiecewisePolynomialInterpolator {
    private static final double ERROR = 1.0E-13;
    private static final double EPS = 1.0E-7;
    private static final double SMALL = 1.0E-14;
    private final HermiteCoefficientsProvider _solver = new HermiteCoefficientsProvider();

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[] yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"(xValues length = yValues length) should be true");
        ArgChecker.isTrue((xValues.length > 2 ? 1 : 0) != 0, (String)"Data points should be >= 3");
        int nDataPts = xValues.length;
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yValues containing Infinity");
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        double[] yValuesSrt = Arrays.copyOf(yValues, nDataPts);
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (double[])yValuesSrt);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        double[] intervals = this._solver.intervalsCalculator(xValuesSrt);
        double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
        double[] first = this.firstDerivativeCalculator(slopes);
        double[][] coefs = this._solver.solve(yValuesSrt, intervals, slopes, first);
        for (int i = 0; i < nDataPts - 1; ++i) {
            double ref = 0.0;
            for (int j = 0; j < 4; ++j) {
                ref += coefs[i][j] * Math.pow(intervals[i], 3 - j);
                ArgChecker.isFalse((boolean)Double.isNaN(coefs[i][j]), (String)"Too large input");
                ArgChecker.isFalse((boolean)Double.isInfinite(coefs[i][j]), (String)"Too large input");
            }
            double bound = Math.max(Math.abs(ref) + Math.abs(yValuesSrt[i + 1]), 0.1);
            ArgChecker.isTrue((Math.abs(ref - yValuesSrt[i + 1]) < 1.0E-13 * bound ? 1 : 0) != 0, (String)"Input is too large/small or data points are too close");
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])coefs), 4, 1);
    }

    @Override
    public PiecewisePolynomialResult interpolate(double[] xValues, double[][] yValuesMatrix) {
        int i;
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValuesMatrix, (String)"yValuesMatrix");
        ArgChecker.isTrue((xValues.length == yValuesMatrix[0].length ? 1 : 0) != 0, (String)"(xValues length = yValuesMatrix's row vector length) should be true");
        ArgChecker.isTrue((xValues.length > 2 ? 1 : 0) != 0, (String)"Data points should be >= 3");
        int nDataPts = xValues.length;
        int yValuesLen = yValuesMatrix[0].length;
        int dim = yValuesMatrix.length;
        for (i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
        }
        for (i = 0; i < yValuesLen; ++i) {
            for (int j = 0; j < dim; ++j) {
                ArgChecker.isFalse((boolean)Double.isNaN(yValuesMatrix[j][i]), (String)"yValuesMatrix containing NaN");
                ArgChecker.isFalse((boolean)Double.isInfinite(yValuesMatrix[j][i]), (String)"yValuesMatrix containing Infinity");
            }
        }
        double[] xValuesSrt = Arrays.copyOf(xValues, nDataPts);
        int[] sortedPositions = IntStream.range(0, nDataPts).toArray();
        DoubleArrayMath.sortPairs((double[])xValuesSrt, (int[])sortedPositions);
        ArgChecker.noDuplicatesSorted((double[])xValuesSrt, (String)"xValues");
        DoubleMatrix[] coefMatrix = new DoubleMatrix[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            double[] yValuesSrt = DoubleArrayMath.reorderedCopy((double[])yValuesMatrix[i2], (int[])sortedPositions);
            double[] intervals = this._solver.intervalsCalculator(xValuesSrt);
            double[] slopes = this._solver.slopesCalculator(yValuesSrt, intervals);
            double[] first = this.firstDerivativeCalculator(slopes);
            coefMatrix[i2] = DoubleMatrix.copyOf((double[][])this._solver.solve(yValuesSrt, intervals, slopes, first));
            for (int k = 0; k < intervals.length; ++k) {
                double ref = 0.0;
                for (int j = 0; j < 4; ++j) {
                    ref += coefMatrix[i2].get(k, j) * Math.pow(intervals[k], 3 - j);
                    ArgChecker.isFalse((boolean)Double.isNaN(coefMatrix[i2].get(k, j)), (String)"Too large input");
                    ArgChecker.isFalse((boolean)Double.isInfinite(coefMatrix[i2].get(k, j)), (String)"Too large input");
                }
                double bound = Math.max(Math.abs(ref) + Math.abs(yValuesSrt[k + 1]), 0.1);
                ArgChecker.isTrue((Math.abs(ref - yValuesSrt[k + 1]) < 1.0E-13 * bound ? 1 : 0) != 0, (String)"Input is too large/small or data points are too close");
            }
        }
        int nIntervals = coefMatrix[0].rowCount();
        int nCoefs = coefMatrix[0].columnCount();
        double[][] resMatrix = new double[dim * nIntervals][nCoefs];
        for (int i3 = 0; i3 < nIntervals; ++i3) {
            for (int j = 0; j < dim; ++j) {
                resMatrix[dim * i3 + j] = coefMatrix[j].row(i3).toArray();
            }
        }
        return new PiecewisePolynomialResult(DoubleArray.copyOf((double[])xValuesSrt), DoubleMatrix.copyOf((double[][])resMatrix), nCoefs, dim);
    }

    @Override
    public PiecewisePolynomialResultsWithSensitivity interpolateWithSensitivity(double[] xValues, double[] yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        ArgChecker.isTrue((xValues.length == yValues.length ? 1 : 0) != 0, (String)"(xValues length = yValues length) should be true");
        ArgChecker.isTrue((xValues.length > 2 ? 1 : 0) != 0, (String)"Data points should be >= 3");
        int nDataPts = xValues.length;
        for (int i = 0; i < nDataPts; ++i) {
            ArgChecker.isFalse((boolean)Double.isNaN(xValues[i]), (String)"xValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(xValues[i]), (String)"xValues containing Infinity");
            ArgChecker.isFalse((boolean)Double.isNaN(yValues[i]), (String)"yValues containing NaN");
            ArgChecker.isFalse((boolean)Double.isInfinite(yValues[i]), (String)"yValues containing Infinity");
        }
        ArgChecker.noDuplicates((double[])xValues, (String)"xValues");
        double[] intervals = this._solver.intervalsCalculator(xValues);
        double[] slopes = this._solver.slopesCalculator(yValues, intervals);
        double[][] slopeSensitivity = this._solver.slopeSensitivityCalculator(intervals);
        DoubleArray[] firstWithSensitivity = this.firstDerivativeWithSensitivityCalculator(yValues, intervals, slopes, slopeSensitivity);
        DoubleMatrix[] resMatrix = this._solver.solveWithSensitivity(yValues, intervals, slopes, slopeSensitivity, firstWithSensitivity);
        for (int k = 0; k < nDataPts; ++k) {
            DoubleMatrix m = resMatrix[k];
            int rows = m.rowCount();
            int cols = m.columnCount();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    ArgChecker.isTrue((boolean)Doubles.isFinite((double)m.get(i, j)), (String)"Matrix contains a NaN or infinite");
                }
            }
        }
        DoubleMatrix coefMatrix = resMatrix[0];
        for (int i = 0; i < nDataPts - 1; ++i) {
            double ref = 0.0;
            for (int j = 0; j < 4; ++j) {
                ref += coefMatrix.get(i, j) * Math.pow(intervals[i], 3 - j);
            }
            double bound = Math.max(Math.abs(ref) + Math.abs(yValues[i + 1]), 0.1);
            ArgChecker.isTrue((Math.abs(ref - yValues[i + 1]) < 1.0E-13 * bound ? 1 : 0) != 0, (String)"Input is too large/small or data points are too close");
        }
        DoubleMatrix[] coefSenseMatrix = new DoubleMatrix[nDataPts - 1];
        System.arraycopy(resMatrix, 1, coefSenseMatrix, 0, nDataPts - 1);
        int nCoefs = coefMatrix.columnCount();
        return new PiecewisePolynomialResultsWithSensitivity(DoubleArray.copyOf((double[])xValues), coefMatrix, nCoefs, 1, coefSenseMatrix);
    }

    private double[] firstDerivativeCalculator(double[] slopes) {
        int nData = slopes.length + 1;
        double[] res = new double[nData];
        double[] slopesExt = this.getExtraPoints(slopes);
        for (int i = 0; i < nData; ++i) {
            if (Math.abs(slopesExt[i + 3] - slopesExt[i + 2]) == 0.0) {
                if (Math.abs(slopesExt[i + 1] - slopesExt[i]) == 0.0) {
                    res[i] = 0.5 * (slopesExt[i + 1] + slopesExt[i + 2]);
                    continue;
                }
                res[i] = slopesExt[i + 2];
                continue;
            }
            res[i] = Math.abs(slopesExt[i + 1] - slopesExt[i]) == 0.0 ? slopesExt[i] : (Math.abs(slopesExt[i + 3] - slopesExt[i + 2]) * slopesExt[i + 1] + Math.abs(slopesExt[i + 1] - slopesExt[i]) * slopesExt[i + 2]) / (Math.abs(slopesExt[i + 3] - slopesExt[i + 2]) + Math.abs(slopesExt[i + 1] - slopesExt[i]));
        }
        return res;
    }

    private DoubleArray[] firstDerivativeWithSensitivityCalculator(double[] yValues, double[] intervals, double[] slopes, double[][] slopeSensitivity) {
        int nData = yValues.length;
        double[] slopesExt = this.getExtraPoints(slopes);
        double[][] slopeSensitivityExtTransp = new double[nData][nData + 3];
        DoubleArray[] res = new DoubleArray[nData + 1];
        DoubleMatrix senseMat = DoubleMatrix.copyOf((double[][])slopeSensitivity);
        for (int i = 0; i < nData; ++i) {
            slopeSensitivityExtTransp[i] = this.getExtraPoints(senseMat.column(i).toArray());
        }
        DoubleArray[] modSlopesWithSensitivity = this.modSlopesWithSensitivityCalculator(slopesExt, slopeSensitivityExtTransp);
        DoubleArray modSlopesWithSense0 = modSlopesWithSensitivity[0];
        double[] first = new double[nData];
        for (int i = 0; i < nData; ++i) {
            double[] tmp = new double[nData];
            double den = modSlopesWithSense0.get(i + 2) + modSlopesWithSense0.get(i);
            if (den == 0.0) {
                first[i] = 0.5 * (slopesExt[i + 1] + slopesExt[i + 2]);
                Arrays.fill(tmp, 0.0);
                double[] yValuesUp = Arrays.copyOf(yValues, nData);
                double[] yValuesDw = Arrays.copyOf(yValues, nData);
                for (int j = 0; j < nData; ++j) {
                    double div = Math.abs(yValues[j]) < 1.0E-14 ? 1.0E-7 : yValues[j] * 1.0E-7;
                    yValuesUp[j] = Math.abs(yValues[j]) < 1.0E-14 ? 1.0E-7 : yValues[j] * 1.0000001;
                    yValuesDw[j] = Math.abs(yValues[j]) < 1.0E-14 ? -1.0E-7 : yValues[j] * 0.9999999;
                    double firstUp = this.firstDerivativeCalculator(this._solver.slopesCalculator(yValuesUp, intervals))[i];
                    double firstDw = this.firstDerivativeCalculator(this._solver.slopesCalculator(yValuesDw, intervals))[i];
                    tmp[j] = 0.5 * (firstUp - firstDw) / div;
                    yValuesUp[j] = yValues[j];
                    yValuesDw[j] = yValues[j];
                }
            } else {
                first[i] = modSlopesWithSense0.get(i + 2) * slopesExt[i + 1] / den + modSlopesWithSense0.get(i) * slopesExt[i + 2] / den;
                for (int k = 0; k < nData; ++k) {
                    tmp[k] = (modSlopesWithSense0.get(i + 2) * slopeSensitivityExtTransp[k][i + 1] + modSlopesWithSense0.get(i) * slopeSensitivityExtTransp[k][i + 2]) / den + (slopesExt[i + 2] - slopesExt[i + 1]) * (modSlopesWithSense0.get(i + 2) * modSlopesWithSensitivity[i + 1].get(k) - modSlopesWithSense0.get(i) * modSlopesWithSensitivity[i + 3].get(k)) / den / den;
                }
            }
            res[i + 1] = DoubleArray.copyOf((double[])tmp);
        }
        res[0] = DoubleArray.copyOf((double[])first);
        return res;
    }

    private DoubleArray[] modSlopesWithSensitivityCalculator(double[] slopesExt, double[][] slopeSensitivityExtTransp) {
        int nData = slopesExt.length - 3;
        double[] modSlopes = new double[nData + 2];
        DoubleArray[] res = new DoubleArray[nData + 3];
        for (int i = 0; i < nData + 2; ++i) {
            int k;
            double[] tmp = new double[nData];
            if (slopesExt[i + 1] == slopesExt[i]) {
                modSlopes[i] = 0.0;
                Arrays.fill(tmp, 0.0);
            } else if (slopesExt[i + 1] > slopesExt[i]) {
                modSlopes[i] = slopesExt[i + 1] - slopesExt[i];
                for (k = 0; k < nData; ++k) {
                    tmp[k] = slopeSensitivityExtTransp[k][i + 1] - slopeSensitivityExtTransp[k][i];
                }
            } else {
                modSlopes[i] = -slopesExt[i + 1] + slopesExt[i];
                for (k = 0; k < nData; ++k) {
                    tmp[k] = -slopeSensitivityExtTransp[k][i + 1] + slopeSensitivityExtTransp[k][i];
                }
            }
            res[i + 1] = DoubleArray.copyOf((double[])tmp);
        }
        res[0] = DoubleArray.copyOf((double[])modSlopes);
        return res;
    }

    private double[] getExtraPoints(double[] data) {
        int nData = data.length + 1;
        double[] res = new double[nData + 3];
        res[0] = 3.0 * data[0] - 2.0 * data[1];
        res[1] = 2.0 * data[0] - data[1];
        res[nData + 1] = 2.0 * data[nData - 2] - data[nData - 3];
        res[nData + 2] = 3.0 * data[nData - 2] - 2.0 * data[nData - 3];
        System.arraycopy(data, 0, res, 2, nData - 1);
        return res;
    }
}

