/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.interpolation.WeightingFunction;

final class SineWeightingFunction
implements WeightingFunction {
    static final SineWeightingFunction INSTANCE = new SineWeightingFunction();

    private SineWeightingFunction() {
    }

    @Override
    public double getWeight(double y) {
        ArgChecker.inRangeInclusive((double)y, (double)0.0, (double)1.0, (String)"y");
        return 0.5 * (Math.sin(Math.PI * (y - 0.5)) + 1.0);
    }

    public String getName() {
        return "Sine";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "Sine weighting function";
    }
}

