/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.FunctionUtils;

public class SmithWilsonCurveFunction {
    public static final SmithWilsonCurveFunction DEFAULT = SmithWilsonCurveFunction.of(0.042);
    private final double omega;

    public static SmithWilsonCurveFunction of(double ufr) {
        return new SmithWilsonCurveFunction(ufr);
    }

    private SmithWilsonCurveFunction(double ufr) {
        this.omega = Math.log(1.0 + ufr);
    }

    public static double gap(double x, double alpha, DoubleArray nodes, DoubleArray weights) {
        int size = nodes.size();
        ArgChecker.isTrue((size == weights.size() ? 1 : 0) != 0, (String)"nodes and weights must be the same size");
        double num = 1.0;
        double den = 0.0;
        for (int i = 0; i < size; ++i) {
            num += alpha * nodes.get(i) * weights.get(i);
            den += Math.sinh(alpha * nodes.get(i)) * weights.get(i);
        }
        return alpha / Math.abs(1.0 - num * Math.exp(alpha * x) / den);
    }

    public double value(double x, double alpha, DoubleArray nodes, DoubleArray weights) {
        int i;
        int size = nodes.size();
        ArgChecker.isTrue((size == weights.size() ? 1 : 0) != 0, (String)"nodes and weights must be the same size");
        double res = 1.0;
        int bound = x < nodes.get(0) ? 0 : FunctionUtils.getLowerBoundIndex(nodes, x) + 1;
        for (i = 0; i < bound; ++i) {
            res += weights.get(i) * this.wilsonFunctionLeft(x, alpha, nodes.get(i));
        }
        for (i = bound; i < size; ++i) {
            res += weights.get(i) * this.wilsonFunctionRight(x, alpha, nodes.get(i));
        }
        return res *= Math.exp(-this.omega * x);
    }

    public double firstDerivative(double x, double alpha, DoubleArray nodes, DoubleArray weights) {
        int i;
        int size = nodes.size();
        ArgChecker.isTrue((size == weights.size() ? 1 : 0) != 0, (String)"nodes and weights must be the same size");
        double res = -this.omega;
        int bound = x < nodes.get(0) ? 0 : FunctionUtils.getLowerBoundIndex(nodes, x) + 1;
        for (i = 0; i < bound; ++i) {
            res += weights.get(i) * this.wilsonFunctionLeftDerivative(x, alpha, nodes.get(i));
        }
        for (i = bound; i < size; ++i) {
            res += weights.get(i) * this.wilsonFunctionRightDerivative(x, alpha, nodes.get(i));
        }
        return res *= Math.exp(-this.omega * x);
    }

    public DoubleArray parameterSensitivity(double x, double alpha, DoubleArray nodes) {
        int i;
        int size = nodes.size();
        double[] res = new double[size];
        double expOmega = Math.exp(-this.omega * x);
        int bound = x < nodes.get(0) ? 0 : FunctionUtils.getLowerBoundIndex(nodes, x) + 1;
        for (i = 0; i < bound; ++i) {
            res[i] = expOmega * this.wilsonFunctionLeft(x, alpha, nodes.get(i));
        }
        for (i = bound; i < size; ++i) {
            res[i] = expOmega * this.wilsonFunctionRight(x, alpha, nodes.get(i));
        }
        return DoubleArray.ofUnsafe((double[])res);
    }

    private double wilsonFunctionRight(double x, double alpha, double node) {
        double alphaX = alpha * x;
        return alphaX - Math.exp(-alpha * node) * Math.sinh(alphaX);
    }

    private double wilsonFunctionRightDerivative(double x, double alpha, double node) {
        double alphaX = alpha * x;
        double expAlphaNode = Math.exp(-alpha * node);
        return -this.omega * (alphaX - expAlphaNode * Math.sinh(alphaX)) + alpha * (1.0 - expAlphaNode * Math.cosh(alphaX));
    }

    private double wilsonFunctionLeft(double x, double alpha, double node) {
        double alphaNode = alpha * node;
        return alphaNode - Math.exp(-alpha * x) * Math.sinh(alphaNode);
    }

    private double wilsonFunctionLeftDerivative(double x, double alpha, double node) {
        double alphaNode = alpha * node;
        double expAlphaX = Math.exp(-alpha * x);
        return -this.omega * (alphaNode - expAlphaX * Math.sinh(alphaNode)) + alpha * expAlphaX * Math.sinh(alphaNode);
    }
}

