/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.interpolation;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.math.impl.interpolation.LinearWeightingFunction;
import com.opengamma.strata.math.impl.interpolation.SineWeightingFunction;
import org.joda.convert.FromString;

public interface WeightingFunction
extends Named {
    @FromString
    public static WeightingFunction of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        if (uniqueName.equals(LinearWeightingFunction.INSTANCE.getName())) {
            return LinearWeightingFunction.INSTANCE;
        }
        if (uniqueName.equals(SineWeightingFunction.INSTANCE.getName())) {
            return SineWeightingFunction.INSTANCE;
        }
        throw new IllegalArgumentException("WeightingFunction name not found: " + uniqueName);
    }

    default public double getWeight(double[] xs, int index, double x) {
        ArgChecker.notNull((Object)xs, (String)"strikes");
        ArgChecker.notNegative((int)index, (String)"index");
        ArgChecker.isTrue((index <= xs.length - 2 ? 1 : 0) != 0, (String)"index cannot be larger than {}, have {}", (Object[])new Object[]{xs.length - 2, index});
        double y = (xs[index + 1] - x) / (xs[index + 1] - xs[index]);
        return this.getWeight(y);
    }

    public double getWeight(double var1);
}

