/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.linearalgebra.CholeskyDecompositionCommonsResult;
import com.opengamma.strata.math.impl.linearalgebra.CholeskyDecompositionResult;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import com.opengamma.strata.math.linearalgebra.Decomposition;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class CholeskyDecompositionCommons
implements Decomposition<CholeskyDecompositionResult> {
    @Override
    public CholeskyDecompositionResult apply(DoubleMatrix x) {
        CholeskyDecomposition cholesky;
        ArgChecker.notNull((Object)x, (String)"x");
        RealMatrix temp = CommonsMathWrapper.wrap(x);
        try {
            cholesky = new CholeskyDecomposition(temp);
        }
        catch (Exception e) {
            throw new MathException(e.toString());
        }
        return new CholeskyDecompositionCommonsResult(cholesky);
    }
}

