/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.linearalgebra.CholeskyDecompositionOpenGammaResult;
import com.opengamma.strata.math.impl.linearalgebra.CholeskyDecompositionResult;
import com.opengamma.strata.math.linearalgebra.Decomposition;

public class CholeskyDecompositionOpenGamma
implements Decomposition<CholeskyDecompositionResult> {
    public static final double DEFAULT_SYMMETRY_THRESHOLD = 1.0E-10;
    public static final double DEFAULT_POSITIVITY_THRESHOLD = 1.0E-10;

    @Override
    public CholeskyDecompositionResult apply(DoubleMatrix x) {
        return this.evaluate(x, 1.0E-10, 1.0E-10);
    }

    public CholeskyDecompositionResult evaluate(DoubleMatrix matrix, double symmetryThreshold, double positivityThreshold) {
        ArgChecker.notNull((Object)matrix, (String)"Matrix null");
        int nbRow = matrix.rowCount();
        int nbCol = matrix.columnCount();
        ArgChecker.isTrue((nbRow == nbCol ? 1 : 0) != 0, (String)"Matrix not square");
        double[][] l = new double[nbRow][nbRow];
        for (int looprow = 0; looprow < nbRow; ++looprow) {
            for (int loopcol = 0; loopcol <= looprow; ++loopcol) {
                double rowcol = matrix.get(looprow, loopcol);
                double colrow = matrix.get(loopcol, looprow);
                double maxValue = Math.max(Math.abs(rowcol), Math.abs(colrow));
                double diff = Math.abs(rowcol - colrow);
                ArgChecker.isTrue((diff <= maxValue * symmetryThreshold ? 1 : 0) != 0, (String)"Matrix not symmetrical");
                l[looprow][loopcol] = rowcol;
            }
        }
        for (int loopcol = 0; loopcol < nbCol; ++loopcol) {
            ArgChecker.isTrue((l[loopcol][loopcol] > positivityThreshold ? 1 : 0) != 0, (String)"Matrix not positive");
            l[loopcol][loopcol] = Math.sqrt(l[loopcol][loopcol]);
            double lInverse = 1.0 / l[loopcol][loopcol];
            for (int looprow = loopcol + 1; looprow < nbRow; ++looprow) {
                double[] dArray = l[looprow];
                int n = loopcol;
                dArray[n] = dArray[n] * lInverse;
            }
            for (int j = loopcol + 1; j < nbRow; ++j) {
                for (int i = j; i < nbRow; ++i) {
                    double[] dArray = l[i];
                    int n = j;
                    dArray[n] = dArray[n] - l[i][loopcol] * l[j][loopcol];
                }
            }
        }
        return new CholeskyDecompositionOpenGammaResult(l);
    }
}

