/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.linearalgebra.LUDecompositionResult;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealVector;

public class LUDecompositionCommonsResult
implements LUDecompositionResult {
    private final double _determinant;
    private final DoubleMatrix _l;
    private final DoubleMatrix _p;
    private final int[] _pivot;
    private final DecompositionSolver _solver;
    private final DoubleMatrix _u;

    public LUDecompositionCommonsResult(LUDecomposition lu) {
        ArgChecker.notNull((Object)lu, (String)"LU decomposition");
        ArgChecker.notNull((Object)lu.getL(), (String)"Matrix is singular; could not perform LU decomposition");
        this._determinant = lu.getDeterminant();
        this._l = CommonsMathWrapper.unwrap(lu.getL());
        this._p = CommonsMathWrapper.unwrap(lu.getP());
        this._pivot = lu.getPivot();
        this._solver = lu.getSolver();
        this._u = CommonsMathWrapper.unwrap(lu.getU());
    }

    @Override
    public double getDeterminant() {
        return this._determinant;
    }

    @Override
    public DoubleMatrix getL() {
        return this._l;
    }

    @Override
    public DoubleMatrix getP() {
        return this._p;
    }

    @Override
    public int[] getPivot() {
        return this._pivot;
    }

    @Override
    public DoubleMatrix getU() {
        return this._u;
    }

    @Override
    public DoubleArray solve(DoubleArray b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return CommonsMathWrapper.unwrap(this._solver.solve(CommonsMathWrapper.wrap(b)));
    }

    @Override
    public double[] solve(double[] b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return this._solver.solve((RealVector)new ArrayRealVector(b)).toArray();
    }

    @Override
    public DoubleMatrix solve(DoubleMatrix b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return CommonsMathWrapper.unwrap(this._solver.solve(CommonsMathWrapper.wrap(b)));
    }
}

