/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.linearalgebra.QRDecompositionResult;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealVector;

public class QRDecompositionCommonsResult
implements QRDecompositionResult {
    private final DoubleMatrix _q;
    private final DoubleMatrix _r;
    private final DoubleMatrix _qTranspose;
    private final DecompositionSolver _solver;

    public QRDecompositionCommonsResult(QRDecomposition qr) {
        ArgChecker.notNull((Object)qr, (String)"qr");
        this._q = CommonsMathWrapper.unwrap(qr.getQ());
        this._r = CommonsMathWrapper.unwrap(qr.getR());
        this._qTranspose = this._q.transpose();
        this._solver = qr.getSolver();
    }

    @Override
    public DoubleMatrix getQ() {
        return this._q;
    }

    @Override
    public DoubleMatrix getQT() {
        return this._qTranspose;
    }

    @Override
    public DoubleMatrix getR() {
        return this._r;
    }

    @Override
    public DoubleArray solve(DoubleArray b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return CommonsMathWrapper.unwrap(this._solver.solve(CommonsMathWrapper.wrap(b)));
    }

    @Override
    public double[] solve(double[] b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return this._solver.solve((RealVector)new ArrayRealVector(b)).toArray();
    }

    @Override
    public DoubleMatrix solve(DoubleMatrix b) {
        ArgChecker.notNull((Object)b, (String)"b");
        return CommonsMathWrapper.unwrap(this._solver.solve(CommonsMathWrapper.wrap(b)));
    }
}

