/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import java.util.Arrays;

public class TridiagonalMatrix
implements Matrix {
    private final double[] _a;
    private final double[] _b;
    private final double[] _c;
    private DoubleMatrix _matrix;

    public TridiagonalMatrix(double[] a, double[] b, double[] c) {
        ArgChecker.notNull((Object)a, (String)"a");
        ArgChecker.notNull((Object)b, (String)"b");
        ArgChecker.notNull((Object)c, (String)"c");
        int n = a.length;
        ArgChecker.isTrue((b.length == n - 1 ? 1 : 0) != 0, (String)"Length of subdiagonal b is incorrect");
        ArgChecker.isTrue((c.length == n - 1 ? 1 : 0) != 0, (String)"Length of subdiagonal c is incorrect");
        this._a = a;
        this._b = b;
        this._c = c;
    }

    public double[] getDiagonalData() {
        return this._a;
    }

    public double[] getDiagonal() {
        return Arrays.copyOf(this._a, this._a.length);
    }

    public double[] getUpperSubDiagonalData() {
        return this._b;
    }

    public double[] getUpperSubDiagonal() {
        return Arrays.copyOf(this._b, this._b.length);
    }

    public double[] getLowerSubDiagonalData() {
        return this._c;
    }

    public double[] getLowerSubDiagonal() {
        return Arrays.copyOf(this._c, this._c.length);
    }

    public DoubleMatrix toDoubleMatrix() {
        if (this._matrix == null) {
            this.calMatrix();
        }
        return this._matrix;
    }

    private void calMatrix() {
        int i;
        int n = this._a.length;
        double[][] data = new double[n][n];
        for (i = 0; i < n; ++i) {
            data[i][i] = this._a[i];
        }
        for (i = 1; i < n; ++i) {
            data[i - 1][i] = this._b[i - 1];
        }
        for (i = 1; i < n; ++i) {
            data[i][i - 1] = this._c[i - 1];
        }
        this._matrix = DoubleMatrix.copyOf((double[][])data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this._a);
        result = prime * result + Arrays.hashCode(this._b);
        result = prime * result + Arrays.hashCode(this._c);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TridiagonalMatrix other = (TridiagonalMatrix)obj;
        if (!Arrays.equals(this._a, other._a)) {
            return false;
        }
        if (!Arrays.equals(this._b, other._b)) {
            return false;
        }
        return Arrays.equals(this._c, other._c);
    }

    public int dimensions() {
        return 2;
    }

    public int size() {
        return this._a.length;
    }

    public double getEntry(int ... index) {
        ArgChecker.notNull((Object)index, (String)"indices");
        int n = this._a.length;
        int i = index[0];
        int j = index[1];
        ArgChecker.isTrue((i >= 0 && i < n ? 1 : 0) != 0, (String)"x index {} out of range. Matrix has {} rows", (Object[])new Object[]{index[0], n});
        ArgChecker.isTrue((j >= 0 && j < n ? 1 : 0) != 0, (String)"y index {} out of range. Matrix has {} columns", (Object[])new Object[]{index[1], n});
        if (i == j) {
            return this._a[i];
        }
        if (i - 1 == j) {
            return this._c[i - 1];
        }
        if (i + 1 == j) {
            return this._b[i];
        }
        return 0.0;
    }
}

