/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.linearalgebra;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.linearalgebra.TridiagonalMatrix;
import java.util.Arrays;

public class TridiagonalSolver {
    public static double[] solvTriDag(TridiagonalMatrix aM, double[] b) {
        int i;
        ArgChecker.notNull((Object)aM, (String)"null matrix");
        ArgChecker.notNull((Object)b, (String)"null vector");
        double[] d = aM.getDiagonal();
        int n = d.length;
        ArgChecker.isTrue((n == b.length ? 1 : 0) != 0, (String)"vector y wrong length for matrix");
        double[] y = Arrays.copyOf(b, n);
        double[] l = aM.getLowerSubDiagonalData();
        double[] u = aM.getUpperSubDiagonalData();
        double[] x = new double[n];
        for (i = 1; i < n; ++i) {
            double m = l[i - 1] / d[i - 1];
            d[i] = d[i] - m * u[i - 1];
            y[i] = y[i] - m * y[i - 1];
        }
        x[n - 1] = y[n - 1] / d[n - 1];
        for (i = n - 2; i >= 0; --i) {
            x[i] = (y[i] - u[i] * x[i + 1]) / d[i];
        }
        return x;
    }

    public static DoubleArray solvTriDag(TridiagonalMatrix aM, DoubleArray b) {
        return DoubleArray.copyOf((double[])TridiagonalSolver.solvTriDag(aM, b.toArray()));
    }

    private TridiagonalSolver() {
    }
}

