/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.matrix;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class CommonsMatrixAlgebra
extends MatrixAlgebra {
    @Override
    public double getCondition(Matrix m) {
        ArgChecker.notNull((Object)m, (String)"m");
        if (m instanceof DoubleMatrix) {
            RealMatrix temp = CommonsMathWrapper.wrap((DoubleMatrix)m);
            SingularValueDecomposition svd = new SingularValueDecomposition(temp);
            return svd.getConditionNumber();
        }
        throw new IllegalArgumentException("Can only find condition number of DoubleMatrix; have " + m.getClass());
    }

    @Override
    public double getDeterminant(Matrix m) {
        ArgChecker.notNull((Object)m, (String)"m");
        if (m instanceof DoubleMatrix) {
            RealMatrix temp = CommonsMathWrapper.wrap((DoubleMatrix)m);
            LUDecomposition lud = new LUDecomposition(temp);
            return lud.getDeterminant();
        }
        throw new IllegalArgumentException("Can only find determinant of DoubleMatrix; have " + m.getClass());
    }

    @Override
    public double getInnerProduct(Matrix m1, Matrix m2) {
        ArgChecker.notNull((Object)m1, (String)"m1");
        ArgChecker.notNull((Object)m2, (String)"m2");
        if (m1 instanceof DoubleArray && m2 instanceof DoubleArray) {
            RealVector t1 = CommonsMathWrapper.wrap((DoubleArray)m1);
            RealVector t2 = CommonsMathWrapper.wrap((DoubleArray)m2);
            return t1.dotProduct(t2);
        }
        throw new IllegalArgumentException("Can only find inner product of DoubleArray; have " + m1.getClass() + " and " + m2.getClass());
    }

    @Override
    public DoubleMatrix getInverse(Matrix m) {
        ArgChecker.notNull((Object)m, (String)"matrix was null");
        if (m instanceof DoubleMatrix) {
            RealMatrix temp = CommonsMathWrapper.wrap((DoubleMatrix)m);
            SingularValueDecomposition sv = new SingularValueDecomposition(temp);
            RealMatrix inv = sv.getSolver().getInverse();
            return CommonsMathWrapper.unwrap(inv);
        }
        throw new IllegalArgumentException("Can only find inverse of DoubleMatrix; have " + m.getClass());
    }

    @Override
    public double getNorm1(Matrix m) {
        ArgChecker.notNull((Object)m, (String)"m");
        if (m instanceof DoubleArray) {
            RealVector temp = CommonsMathWrapper.wrap((DoubleArray)m);
            return temp.getL1Norm();
        }
        if (m instanceof DoubleMatrix) {
            RealMatrix temp = CommonsMathWrapper.wrap((DoubleMatrix)m);
            double max = 0.0;
            for (int col = temp.getColumnDimension() - 1; col >= 0; --col) {
                max = Math.max(max, temp.getColumnVector(col).getL1Norm());
            }
            return max;
        }
        throw new IllegalArgumentException("Can only find norm1 of DoubleMatrix; have " + m.getClass());
    }

    @Override
    public double getNorm2(Matrix m) {
        ArgChecker.notNull((Object)m, (String)"m");
        if (m instanceof DoubleArray) {
            RealVector temp = CommonsMathWrapper.wrap((DoubleArray)m);
            return temp.getNorm();
        }
        if (m instanceof DoubleMatrix) {
            RealMatrix temp = CommonsMathWrapper.wrap((DoubleMatrix)m);
            SingularValueDecomposition svd = new SingularValueDecomposition(temp);
            return svd.getNorm();
        }
        throw new IllegalArgumentException("Can only find norm2 of DoubleMatrix; have " + m.getClass());
    }

    @Override
    public double getNormInfinity(Matrix m) {
        ArgChecker.notNull((Object)m, (String)"m");
        if (m instanceof DoubleArray) {
            RealVector temp = CommonsMathWrapper.wrap((DoubleArray)m);
            return temp.getLInfNorm();
        }
        if (m instanceof DoubleMatrix) {
            RealMatrix temp = CommonsMathWrapper.wrap((DoubleMatrix)m);
            double max = 0.0;
            for (int row = temp.getRowDimension() - 1; row >= 0; --row) {
                max = Math.max(max, temp.getRowVector(row).getL1Norm());
            }
            return max;
        }
        throw new IllegalArgumentException("Can only find normInfinity of DoubleMatrix; have " + m.getClass());
    }

    @Override
    public DoubleMatrix getOuterProduct(Matrix m1, Matrix m2) {
        ArgChecker.notNull((Object)m1, (String)"m1");
        ArgChecker.notNull((Object)m2, (String)"m2");
        if (m1 instanceof DoubleArray && m2 instanceof DoubleArray) {
            RealVector t1 = CommonsMathWrapper.wrap((DoubleArray)m1);
            RealVector t2 = CommonsMathWrapper.wrap((DoubleArray)m2);
            return CommonsMathWrapper.unwrap(t1.outerProduct(t2));
        }
        throw new IllegalArgumentException("Can only find outer product of DoubleArray; have " + m1.getClass() + " and " + m2.getClass());
    }

    @Override
    public DoubleMatrix getPower(Matrix m, int p) {
        ArgChecker.notNull((Object)m, (String)"m");
        if (!(m instanceof DoubleMatrix)) {
            throw new IllegalArgumentException("Can only find powers of DoubleMatrix; have " + m.getClass());
        }
        RealMatrix temp = CommonsMathWrapper.wrap((DoubleMatrix)m);
        return CommonsMathWrapper.unwrap(temp.power(p));
    }

    @Override
    public DoubleMatrix getPower(Matrix m, double p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getTrace(Matrix m) {
        ArgChecker.notNull((Object)m, (String)"m");
        if (m instanceof DoubleMatrix) {
            RealMatrix temp = CommonsMathWrapper.wrap((DoubleMatrix)m);
            return temp.getTrace();
        }
        throw new IllegalArgumentException("Can only find trace of DoubleMatrix; have " + m.getClass());
    }

    @Override
    public DoubleMatrix getTranspose(Matrix m) {
        ArgChecker.notNull((Object)m, (String)"m");
        if (m instanceof DoubleMatrix) {
            RealMatrix temp = CommonsMathWrapper.wrap((DoubleMatrix)m);
            return CommonsMathWrapper.unwrap(temp.transpose());
        }
        throw new IllegalArgumentException("Can only find transpose of DoubleMatrix; have " + m.getClass());
    }

    @Override
    public Matrix multiply(Matrix m1, Matrix m2) {
        ArgChecker.notNull((Object)m1, (String)"m1");
        ArgChecker.notNull((Object)m2, (String)"m2");
        ArgChecker.isTrue((!(m1 instanceof DoubleArray) ? 1 : 0) != 0, (String)"Cannot have 1D matrix as first argument");
        if (m1 instanceof DoubleMatrix) {
            RealMatrix t2;
            RealMatrix t1 = CommonsMathWrapper.wrap((DoubleMatrix)m1);
            if (m2 instanceof DoubleArray) {
                t2 = CommonsMathWrapper.wrapAsMatrix((DoubleArray)m2);
            } else if (m2 instanceof DoubleMatrix) {
                t2 = CommonsMathWrapper.wrap((DoubleMatrix)m2);
            } else {
                throw new IllegalArgumentException("Can only have 1D or 2D matrix as second argument");
            }
            return CommonsMathWrapper.unwrap(t1.multiply(t2));
        }
        throw new IllegalArgumentException("Can only multiply 2D and 1D matrices");
    }
}

