/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.matrix;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;

public abstract class MatrixAlgebra {
    public Matrix add(Matrix m1, Matrix m2) {
        ArgChecker.notNull((Object)m1, (String)"m1");
        ArgChecker.notNull((Object)m2, (String)"m2");
        if (m1 instanceof DoubleArray) {
            if (m2 instanceof DoubleArray) {
                DoubleArray array1 = (DoubleArray)m1;
                DoubleArray array2 = (DoubleArray)m2;
                return array1.plus(array2);
            }
            throw new IllegalArgumentException("Tried to add a " + m1.getClass() + " and " + m2.getClass());
        }
        if (m1 instanceof DoubleMatrix) {
            if (m2 instanceof DoubleMatrix) {
                DoubleMatrix matrix1 = (DoubleMatrix)m1;
                DoubleMatrix matrix2 = (DoubleMatrix)m2;
                return matrix1.plus(matrix2);
            }
            throw new IllegalArgumentException("Tried to add a " + m1.getClass() + " and " + m2.getClass());
        }
        throw new UnsupportedOperationException();
    }

    public Matrix divide(Matrix m1, Matrix m2) {
        ArgChecker.notNull((Object)m1, (String)"m1");
        ArgChecker.notNull((Object)m2, (String)"m2");
        ArgChecker.isTrue((boolean)(m1 instanceof DoubleMatrix), (String)"Can only divide a 2D matrix");
        ArgChecker.isTrue((boolean)(m2 instanceof DoubleMatrix), (String)"Can only perform division with a 2D matrix");
        return this.multiply(m1, (Matrix)this.getInverse(m2));
    }

    public Matrix kroneckerProduct(Matrix m1, Matrix m2) {
        ArgChecker.notNull((Object)m1, (String)"m1");
        ArgChecker.notNull((Object)m2, (String)"m2");
        if (m1 instanceof DoubleMatrix && m2 instanceof DoubleMatrix) {
            DoubleMatrix matrix1 = (DoubleMatrix)m1;
            DoubleMatrix matrix2 = (DoubleMatrix)m2;
            int aRows = matrix1.rowCount();
            int aCols = matrix1.columnCount();
            int bRows = matrix2.rowCount();
            int bCols = matrix2.columnCount();
            int rRows = aRows * bRows;
            int rCols = aCols * bCols;
            double[][] res = new double[rRows][rCols];
            for (int i = 0; i < aRows; ++i) {
                for (int j = 0; j < aCols; ++j) {
                    double t = matrix1.get(i, j);
                    if (t == 0.0) continue;
                    for (int k = 0; k < bRows; ++k) {
                        for (int l = 0; l < bCols; ++l) {
                            res[i * bRows + k][j * bCols + l] = t * matrix2.get(k, l);
                        }
                    }
                }
            }
            return DoubleMatrix.ofUnsafe((double[][])res);
        }
        throw new IllegalArgumentException("Can only calculate the Kronecker product of two DoubleMatrix.");
    }

    public abstract Matrix multiply(Matrix var1, Matrix var2);

    public Matrix scale(Matrix m, double scale) {
        ArgChecker.notNull((Object)m, (String)"m");
        if (m instanceof DoubleArray) {
            return ((DoubleArray)m).multipliedBy(scale);
        }
        if (m instanceof DoubleMatrix) {
            return ((DoubleMatrix)m).multipliedBy(scale);
        }
        throw new UnsupportedOperationException();
    }

    public Matrix subtract(Matrix m1, Matrix m2) {
        ArgChecker.notNull((Object)m1, (String)"m1");
        ArgChecker.notNull((Object)m2, (String)"m2");
        if (m1 instanceof DoubleArray) {
            if (m2 instanceof DoubleArray) {
                DoubleArray array1 = (DoubleArray)m1;
                DoubleArray array2 = (DoubleArray)m2;
                return array1.minus(array2);
            }
            throw new IllegalArgumentException("Tried to subtract a " + m1.getClass() + " and " + m2.getClass());
        }
        if (m1 instanceof DoubleMatrix) {
            if (m2 instanceof DoubleMatrix) {
                DoubleMatrix matrix1 = (DoubleMatrix)m1;
                DoubleMatrix matrix2 = (DoubleMatrix)m2;
                return matrix1.minus(matrix2);
            }
            throw new IllegalArgumentException("Tried to subtract a " + m1.getClass() + " and " + m2.getClass());
        }
        throw new UnsupportedOperationException();
    }

    public abstract double getCondition(Matrix var1);

    public abstract double getDeterminant(Matrix var1);

    public abstract DoubleMatrix getInverse(Matrix var1);

    public abstract double getInnerProduct(Matrix var1, Matrix var2);

    public abstract DoubleMatrix getOuterProduct(Matrix var1, Matrix var2);

    public abstract double getNorm1(Matrix var1);

    public abstract double getNorm2(Matrix var1);

    public abstract double getNormInfinity(Matrix var1);

    public abstract DoubleMatrix getPower(Matrix var1, int var2);

    public abstract DoubleMatrix getPower(Matrix var1, double var2);

    public abstract double getTrace(Matrix var1);

    public abstract DoubleMatrix getTranspose(Matrix var1);

    public DoubleMatrix matrixTransposeMultiplyMatrix(DoubleMatrix a) {
        ArgChecker.notNull((Object)a, (String)"a");
        int n = a.rowCount();
        int m = a.columnCount();
        double[][] data = new double[m][m];
        for (int i = 0; i < m; ++i) {
            double sum = 0.0;
            for (int k = 0; k < n; ++k) {
                sum += a.get(k, i) * a.get(k, i);
            }
            data[i][i] = sum;
            for (int j = i + 1; j < m; ++j) {
                sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += a.get(k, i) * a.get(k, j);
                }
                data[i][j] = sum;
                data[j][i] = sum;
            }
        }
        return DoubleMatrix.ofUnsafe((double[][])data);
    }
}

