/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.matrix;

import com.opengamma.strata.math.impl.matrix.CommonsMatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import java.util.HashMap;
import java.util.Map;

public final class MatrixAlgebraFactory {
    public static final String COMMONS = "Commons";
    public static final String OG = "OG";
    public static final CommonsMatrixAlgebra COMMONS_ALGEBRA = new CommonsMatrixAlgebra();
    public static final OGMatrixAlgebra OG_ALGEBRA = new OGMatrixAlgebra();
    private static final Map<String, MatrixAlgebra> STATIC_INSTANCES = new HashMap<String, MatrixAlgebra>();
    private static final Map<Class<?>, String> INSTANCE_NAMES = new HashMap();

    private MatrixAlgebraFactory() {
    }

    public static MatrixAlgebra getMatrixAlgebra(String algebraName) {
        if (STATIC_INSTANCES.containsKey(algebraName)) {
            return STATIC_INSTANCES.get(algebraName);
        }
        throw new IllegalArgumentException("Matrix algebra " + algebraName + " not found");
    }

    public static String getMatrixAlgebraName(MatrixAlgebra algebra) {
        if (algebra == null) {
            return null;
        }
        return INSTANCE_NAMES.get(algebra.getClass());
    }

    static {
        STATIC_INSTANCES.put(COMMONS, COMMONS_ALGEBRA);
        INSTANCE_NAMES.put(CommonsMatrixAlgebra.class, COMMONS);
        STATIC_INSTANCES.put(OG, OG_ALGEBRA);
        INSTANCE_NAMES.put(OGMatrixAlgebra.class, OG);
    }
}

