/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.minimization;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.ArgChecker;
import java.util.function.Function;

public abstract class MinimumBracketer {
    private static final double ZERO = 1.0E-15;
    protected static final double GOLDEN = 0.61803399;

    public abstract double[] getBracketedPoints(Function<Double, Double> var1, double var2, double var4);

    protected void checkInputs(Function<Double, Double> f, double xLower, double xUpper) {
        ArgChecker.notNull(f, (String)"function");
        if (DoubleMath.fuzzyEquals((double)xLower, (double)xUpper, (double)1.0E-15)) {
            throw new IllegalArgumentException("Lower and upper values were not distinct");
        }
    }
}

