/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.minimization;

import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.minimization.MinimumBracketer;
import java.util.function.Function;

public class ParabolicMinimumBracketer
extends MinimumBracketer {
    private static final double ZERO = 1.0E-20;
    private static final int MAX_ITER = 100;
    private static final int MAX_MAGNIFICATION = 100;
    private static final double MAGNIFICATION = 1.61803399;

    @Override
    public double[] getBracketedPoints(Function<Double, Double> f, double xLower, double xUpper) {
        double temp;
        this.checkInputs(f, xLower, xUpper);
        double x1 = xLower;
        double x2 = xUpper;
        double f1 = f.apply(x1);
        double f2 = f.apply(x2);
        if (f2 > f1) {
            temp = x2;
            x2 = x1;
            x1 = temp;
            temp = f2;
            f2 = f1;
            f1 = temp;
        }
        double x3 = x2 + 1.61803399 * (x2 - x1);
        double f3 = f.apply(x3);
        if (x1 < x2 && x2 < x3 && f2 < f1 && f2 < f3 || x1 > x2 && x2 > x3 && f2 < f1 && f2 < f3) {
            return new double[]{x1, x2, x3};
        }
        int count = 0;
        while (count < 100) {
            double fu;
            if (f2 < f3) {
                return new double[]{x1, x2, x3};
            }
            ++count;
            double r = (x2 - x1) * (f2 - f3);
            double q = (x2 - x1) * (f2 - f1);
            double u = x2 - ((x2 - x3) * q - (x2 - x1) * r) / (2.0 * Math.copySign(Math.max(Math.abs(q - r), 1.0E-20), q - r));
            double uLim = x2 + 100.0 * (x3 - x2);
            if ((x2 - u) * (u - x3) > 0.0) {
                fu = f.apply(u);
                if (fu < f3) {
                    x1 = x2;
                    x2 = u;
                    return new double[]{x1, x2, x3};
                }
                if (fu > f2) {
                    x3 = u;
                    return new double[]{x1, x2, x3};
                }
                u = x3 + 1.61803399 * (x3 - x2);
                fu = f.apply(u);
            } else if ((x3 - u) * (u - uLim) > 0.0) {
                fu = f.apply(u);
                if (fu < f3) {
                    temp = u + 1.61803399 * (u - x3);
                    x2 = x3;
                    x3 = u;
                    u = temp;
                    f2 = f3;
                    f3 = fu;
                    fu = f.apply(u);
                }
            } else if ((u - uLim) * (uLim - x3) >= 0.0) {
                u = uLim;
                fu = f.apply(u);
            } else {
                u = x3 + 1.61803399 * (x3 - x2);
                fu = f.apply(u);
            }
            x1 = x2;
            x2 = x3;
            x3 = u;
            f1 = f2;
            f2 = f3;
            f3 = fu;
        }
        throw new MathException("Could not bracket a minimum in 100 attempts");
    }
}

