/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.minimization;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.minimization.NonLinearParameterTransforms;
import com.opengamma.strata.math.impl.minimization.ParameterLimitsTransform;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;

public class UncoupledParameterTransforms
implements NonLinearParameterTransforms {
    private final DoubleArray _startValues;
    private final ParameterLimitsTransform[] _transforms;
    private final boolean[] _freeParameters;
    private final int _nMP;
    private final int _nFP;

    public UncoupledParameterTransforms(DoubleArray startValues, ParameterLimitsTransform[] transforms, BitSet fixed) {
        ArgChecker.notNull((Object)startValues, (String)"null start values");
        ArgChecker.notEmpty((Object[])transforms, (String)"must specify transforms");
        ArgChecker.notNull((Object)fixed, (String)"must specify what is fixed (even if none)");
        this._nMP = startValues.size();
        ArgChecker.isTrue((this._nMP == transforms.length ? 1 : 0) != 0, (String)"Have {}-dimensional start value but {} transforms", (Object[])new Object[]{this._nMP, transforms.length});
        this._freeParameters = new boolean[this._nMP];
        for (int i = 0; i < this._nMP; ++i) {
            this._freeParameters[i] = i < fixed.size() ? !fixed.get(i) : true;
        }
        int count = fixed.cardinality();
        ArgChecker.isTrue((count < this._nMP ? 1 : 0) != 0, (String)"all parameters are fixed");
        this._nFP = this._nMP - count;
        this._startValues = startValues;
        this._transforms = transforms;
    }

    @Override
    public int getNumberOfModelParameters() {
        return this._nMP;
    }

    @Override
    public int getNumberOfFittingParameters() {
        return this._nFP;
    }

    @Override
    public DoubleArray transform(DoubleArray functionParameters) {
        ArgChecker.notNull((Object)functionParameters, (String)"function parameters");
        ArgChecker.isTrue((functionParameters.size() == this._nMP ? 1 : 0) != 0, (String)"functionParameters wrong dimension");
        double[] fittingParameter = new double[this._nFP];
        int j = 0;
        for (int i = 0; i < this._nMP; ++i) {
            if (!this._freeParameters[i]) continue;
            fittingParameter[j] = this._transforms[i].transform(functionParameters.get(i));
            ++j;
        }
        return DoubleArray.copyOf((double[])fittingParameter);
    }

    @Override
    public DoubleArray inverseTransform(DoubleArray fittingParameters) {
        ArgChecker.notNull((Object)fittingParameters, (String)"fitting parameters");
        ArgChecker.isTrue((fittingParameters.size() == this._nFP ? 1 : 0) != 0, (String)"fittingParameter wrong dimension");
        double[] modelParameter = new double[this._nMP];
        int j = 0;
        for (int i = 0; i < this._nMP; ++i) {
            if (this._freeParameters[i]) {
                modelParameter[i] = this._transforms[i].inverseTransform(fittingParameters.get(j));
                ++j;
                continue;
            }
            modelParameter[i] = this._startValues.get(i);
        }
        return DoubleArray.copyOf((double[])modelParameter);
    }

    @Override
    public DoubleMatrix jacobian(DoubleArray functionParameters) {
        ArgChecker.notNull((Object)functionParameters, (String)"function parameters");
        ArgChecker.isTrue((functionParameters.size() == this._nMP ? 1 : 0) != 0, (String)"functionParameters wrong dimension");
        double[][] jac = new double[this._nFP][this._nMP];
        int j = 0;
        for (int i = 0; i < this._nMP; ++i) {
            if (!this._freeParameters[i]) continue;
            jac[j][i] = this._transforms[i].transformGradient(functionParameters.get(i));
            ++j;
        }
        return DoubleMatrix.copyOf((double[][])jac);
    }

    @Override
    public DoubleMatrix inverseJacobian(DoubleArray fittingParameters) {
        ArgChecker.notNull((Object)fittingParameters, (String)"fitting parameters");
        ArgChecker.isTrue((fittingParameters.size() == this._nFP ? 1 : 0) != 0, (String)"fitting parameters wrong dimension");
        double[][] jac = new double[this._nMP][this._nFP];
        int[] p = new int[this._nMP];
        int[] q = new int[this._nMP];
        int t = 0;
        for (int i = 0; i < this._nMP; ++i) {
            if (!this._freeParameters[i]) continue;
            p[t] = i;
            q[t] = t;
            ++t;
        }
        for (int i = 0; i < t; ++i) {
            int pderef = p[i];
            int qderef = q[i];
            jac[pderef][qderef] = this._transforms[pderef].inverseTransformGradient(fittingParameters.get(qderef));
        }
        return DoubleMatrix.copyOf((double[][])jac);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this._freeParameters);
        result = prime * result + this._startValues.hashCode();
        result = prime * result + Arrays.hashCode(this._transforms);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UncoupledParameterTransforms other = (UncoupledParameterTransforms)obj;
        if (!Arrays.equals(this._freeParameters, other._freeParameters)) {
            return false;
        }
        if (!Objects.equals(this._startValues, other._startValues)) {
            return false;
        }
        return Arrays.equals(this._transforms, other._transforms);
    }
}

