/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.regression;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.matrix.CommonsMatrixAlgebra;
import com.opengamma.strata.math.impl.regression.LeastSquaresRegression;
import com.opengamma.strata.math.impl.regression.LeastSquaresRegressionResult;
import com.opengamma.strata.math.impl.regression.WeightedLeastSquaresRegressionResult;

public class GeneralizedLeastSquaresRegression
extends LeastSquaresRegression {
    private static CommonsMatrixAlgebra ALGEBRA = new CommonsMatrixAlgebra();

    @Override
    public LeastSquaresRegressionResult regress(double[][] x, double[][] weights, double[] y, boolean useIntercept) {
        if (weights == null) {
            throw new IllegalArgumentException("Cannot perform GLS regression without an array of weights");
        }
        this.checkData(x, weights, y);
        double[][] dep = this.addInterceptVariable(x, useIntercept);
        double[] indep = new double[y.length];
        double[][] wArray = new double[y.length][y.length];
        for (int i = 0; i < y.length; ++i) {
            indep[i] = y[i];
            for (int j = 0; j < y.length; ++j) {
                wArray[i][j] = weights[i][j];
            }
        }
        DoubleMatrix matrix = DoubleMatrix.copyOf((double[][])dep);
        DoubleArray vector = DoubleArray.copyOf((double[])indep);
        DoubleMatrix w = DoubleMatrix.copyOf((double[][])wArray);
        DoubleMatrix transpose = ALGEBRA.getTranspose((Matrix)matrix);
        DoubleMatrix betasVector = (DoubleMatrix)ALGEBRA.multiply(ALGEBRA.multiply(ALGEBRA.multiply((Matrix)ALGEBRA.getInverse(ALGEBRA.multiply((Matrix)transpose, ALGEBRA.multiply((Matrix)w, (Matrix)matrix))), (Matrix)transpose), (Matrix)w), (Matrix)vector);
        double[] yModel = super.writeArrayAsVector(((DoubleMatrix)ALGEBRA.multiply((Matrix)matrix, (Matrix)betasVector)).toArray());
        double[] betas = super.writeArrayAsVector(betasVector.toArray());
        return this.getResultWithStatistics(x, y, betas, yModel, useIntercept);
    }

    private LeastSquaresRegressionResult getResultWithStatistics(double[][] x, double[] y, double[] betas, double[] yModel, boolean useIntercept) {
        int n = x.length;
        double[] residuals = new double[n];
        for (int i = 0; i < n; ++i) {
            residuals[i] = y[i] - yModel[i];
        }
        return new WeightedLeastSquaresRegressionResult(betas, residuals, 0.0, null, 0.0, 0.0, null, null, useIntercept);
    }
}

