/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.regression;

import com.opengamma.strata.collect.ArgChecker;
import java.util.Arrays;

public class LeastSquaresRegressionResult {
    private final double[] _residuals;
    private final double[] _betas;
    private final double _meanSquareError;
    private final double[] _standardErrorOfBeta;
    private final double _rSquared;
    private final double _rSquaredAdjusted;
    private final double[] _tStats;
    private final double[] _pValues;
    private final boolean _hasIntercept;

    public LeastSquaresRegressionResult(LeastSquaresRegressionResult result) {
        ArgChecker.notNull((Object)result, (String)"regression result");
        this._betas = result.getBetas();
        this._residuals = result.getResiduals();
        this._meanSquareError = result.getMeanSquareError();
        this._standardErrorOfBeta = result.getStandardErrorOfBetas();
        this._rSquared = result.getRSquared();
        this._rSquaredAdjusted = result.getAdjustedRSquared();
        this._tStats = result.getTStatistics();
        this._pValues = result.getPValues();
        this._hasIntercept = result.hasIntercept();
    }

    public LeastSquaresRegressionResult(double[] betas, double[] residuals, double meanSquareError, double[] standardErrorOfBeta, double rSquared, double rSquaredAdjusted, double[] tStats, double[] pValues, boolean hasIntercept) {
        this._betas = betas;
        this._residuals = residuals;
        this._meanSquareError = meanSquareError;
        this._standardErrorOfBeta = standardErrorOfBeta;
        this._rSquared = rSquared;
        this._rSquaredAdjusted = rSquaredAdjusted;
        this._tStats = tStats;
        this._pValues = pValues;
        this._hasIntercept = hasIntercept;
    }

    public double[] getBetas() {
        return this._betas;
    }

    public double[] getResiduals() {
        return this._residuals;
    }

    public double getMeanSquareError() {
        return this._meanSquareError;
    }

    public double[] getStandardErrorOfBetas() {
        return this._standardErrorOfBeta;
    }

    public double getRSquared() {
        return this._rSquared;
    }

    public double getAdjustedRSquared() {
        return this._rSquaredAdjusted;
    }

    public double[] getTStatistics() {
        return this._tStats;
    }

    public double[] getPValues() {
        return this._pValues;
    }

    public boolean hasIntercept() {
        return this._hasIntercept;
    }

    public double getPredictedValue(double[] x) {
        ArgChecker.notNull((Object)x, (String)"x");
        double[] betas = this.getBetas();
        if (this.hasIntercept() ? x.length != betas.length - 1 : x.length != betas.length) {
            throw new IllegalArgumentException("Number of variables did not match number used in regression");
        }
        double sum = 0.0;
        for (int i = 0; i < (this.hasIntercept() ? x.length + 1 : x.length); ++i) {
            if (this.hasIntercept()) {
                if (i == 0) {
                    sum += betas[0];
                    continue;
                }
                sum += betas[i] * x[i - 1];
                continue;
            }
            sum += x[i] * betas[i];
        }
        return sum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this._betas);
        result = prime * result + (this._hasIntercept ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this._meanSquareError);
        result = prime * result + (int)(temp ^ temp >>> 32);
        result = prime * result + Arrays.hashCode(this._pValues);
        temp = Double.doubleToLongBits(this._rSquared);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this._rSquaredAdjusted);
        result = prime * result + (int)(temp ^ temp >>> 32);
        result = prime * result + Arrays.hashCode(this._residuals);
        result = prime * result + Arrays.hashCode(this._standardErrorOfBeta);
        result = prime * result + Arrays.hashCode(this._tStats);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeastSquaresRegressionResult other = (LeastSquaresRegressionResult)obj;
        if (!Arrays.equals(this._betas, other._betas)) {
            return false;
        }
        if (this._hasIntercept != other._hasIntercept) {
            return false;
        }
        if (Double.doubleToLongBits(this._meanSquareError) != Double.doubleToLongBits(other._meanSquareError)) {
            return false;
        }
        if (!Arrays.equals(this._pValues, other._pValues)) {
            return false;
        }
        if (Double.doubleToLongBits(this._rSquared) != Double.doubleToLongBits(other._rSquared)) {
            return false;
        }
        if (Double.doubleToLongBits(this._rSquaredAdjusted) != Double.doubleToLongBits(other._rSquaredAdjusted)) {
            return false;
        }
        if (!Arrays.equals(this._residuals, other._residuals)) {
            return false;
        }
        if (!Arrays.equals(this._standardErrorOfBeta, other._standardErrorOfBeta)) {
            return false;
        }
        return Arrays.equals(this._tStats, other._tStats);
    }
}

