/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.regression;

import com.opengamma.strata.math.impl.regression.LeastSquaresRegressionResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedVariableLeastSquaresRegressionResult
extends LeastSquaresRegressionResult {
    private static final Logger log = LoggerFactory.getLogger(NamedVariableLeastSquaresRegressionResult.class);
    private final List<String> _independentVariableNames;
    private final LeastSquaresRegressionResult _result;
    private static final String INTERCEPT_STRING = "Intercept";

    public NamedVariableLeastSquaresRegressionResult(List<String> independentVariableNames, LeastSquaresRegressionResult result) {
        super(result);
        if (independentVariableNames == null) {
            throw new IllegalArgumentException("List of independent variable names was null");
        }
        this._independentVariableNames = new ArrayList<String>();
        if (result.hasIntercept()) {
            if (independentVariableNames.size() != result.getBetas().length - 1) {
                throw new IllegalArgumentException("Length of variable name array did not match number of results in the regression");
            }
            this._independentVariableNames.add(INTERCEPT_STRING);
        } else if (independentVariableNames.size() != result.getBetas().length) {
            throw new IllegalArgumentException("Length of variable name array did not match number of results in the regression");
        }
        this._independentVariableNames.addAll(independentVariableNames);
        this._result = result;
    }

    public List<String> getIndependentVariableNames() {
        return this._independentVariableNames;
    }

    public LeastSquaresRegressionResult getResult() {
        return this._result;
    }

    public Double getPredictedValue(Map<String, Double> namesAndValues) {
        if (namesAndValues == null) {
            throw new IllegalArgumentException("Map was null");
        }
        if (namesAndValues.isEmpty()) {
            log.warn("Map was empty: returning 0");
            return 0.0;
        }
        double[] betas = this.getBetas();
        double sum = 0.0;
        if (this.hasIntercept() ? namesAndValues.size() < betas.length - 1 : namesAndValues.size() < betas.length) {
            throw new IllegalArgumentException("Number of named variables in map was smaller than that in regression");
        }
        int i = this.hasIntercept() ? 1 : 0;
        for (String name : this.getIndependentVariableNames()) {
            if (name.equals(INTERCEPT_STRING)) {
                sum += betas[0];
                continue;
            }
            if (!namesAndValues.containsKey(name) || namesAndValues.get(name) == null) {
                throw new IllegalArgumentException("Do not have value for " + name);
            }
            sum += betas[i++] * namesAndValues.get(name);
        }
        return sum;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this._independentVariableNames == null ? 0 : this._independentVariableNames.hashCode());
        result = prime * result + (this._result == null ? 0 : this._result.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedVariableLeastSquaresRegressionResult other = (NamedVariableLeastSquaresRegressionResult)obj;
        if (this._independentVariableNames == null ? other._independentVariableNames != null : !this._independentVariableNames.equals(other._independentVariableNames)) {
            return false;
        }
        return !(this._result == null ? other._result != null : !this._result.equals(other._result));
    }
}

