/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.regression;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.matrix.CommonsMatrixAlgebra;
import com.opengamma.strata.math.impl.regression.LeastSquaresRegression;
import com.opengamma.strata.math.impl.regression.LeastSquaresRegressionResult;
import org.apache.commons.math3.distribution.TDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrdinaryLeastSquaresRegression
extends LeastSquaresRegression {
    private static final Logger log = LoggerFactory.getLogger(OrdinaryLeastSquaresRegression.class);
    private CommonsMatrixAlgebra _algebra = new CommonsMatrixAlgebra();

    @Override
    public LeastSquaresRegressionResult regress(double[][] x, double[][] weights, double[] y, boolean useIntercept) {
        if (weights != null) {
            log.info("Weights were provided for OLS regression: they will be ignored");
        }
        return this.regress(x, y, useIntercept);
    }

    public LeastSquaresRegressionResult regress(double[][] x, double[] y, boolean useIntercept) {
        this.checkData(x, y);
        double[][] indep = this.addInterceptVariable(x, useIntercept);
        double[] dep = new double[y.length];
        for (int i = 0; i < y.length; ++i) {
            dep[i] = y[i];
        }
        DoubleMatrix matrix = DoubleMatrix.copyOf((double[][])indep);
        DoubleArray vector = DoubleArray.copyOf((double[])dep);
        DoubleMatrix transpose = this._algebra.getTranspose((Matrix)matrix);
        DoubleMatrix betasVector = (DoubleMatrix)this._algebra.multiply(this._algebra.multiply((Matrix)this._algebra.getInverse(this._algebra.multiply((Matrix)transpose, (Matrix)matrix)), (Matrix)transpose), (Matrix)vector);
        double[] yModel = super.writeArrayAsVector(((DoubleMatrix)this._algebra.multiply((Matrix)matrix, (Matrix)betasVector)).toArray());
        double[] betas = super.writeArrayAsVector(betasVector.toArray());
        return this.getResultWithStatistics(x, y, betas, yModel, transpose, matrix, useIntercept);
    }

    private LeastSquaresRegressionResult getResultWithStatistics(double[][] x, double[] y, double[] betas, double[] yModel, DoubleMatrix transpose, DoubleMatrix matrix, boolean useIntercept) {
        double yMean = 0.0;
        for (double y1 : y) {
            yMean += y1;
        }
        yMean /= (double)y.length;
        double totalSumOfSquares = 0.0;
        double errorSumOfSquares = 0.0;
        int n = x.length;
        int k = betas.length;
        double[] residuals = new double[n];
        double[] stdErrorBetas = new double[k];
        double[] tStats = new double[k];
        double[] pValues = new double[k];
        for (int i = 0; i < n; ++i) {
            totalSumOfSquares += (y[i] - yMean) * (y[i] - yMean);
            residuals[i] = y[i] - yModel[i];
            errorSumOfSquares += residuals[i] * residuals[i];
        }
        double regressionSumOfSquares = totalSumOfSquares - errorSumOfSquares;
        double[][] covarianceBetas = this.convertArray(this._algebra.getInverse(this._algebra.multiply((Matrix)transpose, (Matrix)matrix)).toArray());
        double rSquared = regressionSumOfSquares / totalSumOfSquares;
        double adjustedRSquared = 1.0 - (1.0 - rSquared) * ((double)n - 1.0) / (double)(n - k);
        double meanSquareError = errorSumOfSquares / (double)(n - k);
        TDistribution studentT = new TDistribution((double)(n - k));
        for (int i = 0; i < k; ++i) {
            stdErrorBetas[i] = Math.sqrt(meanSquareError * covarianceBetas[i][i]);
            tStats[i] = betas[i] / stdErrorBetas[i];
            pValues[i] = 1.0 - studentT.cumulativeProbability(Math.abs(tStats[i]));
        }
        return new LeastSquaresRegressionResult(betas, residuals, meanSquareError, stdErrorBetas, rSquared, adjustedRSquared, tStats, pValues, useIntercept);
    }
}

