/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.regression;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.matrix.CommonsMatrixAlgebra;
import com.opengamma.strata.math.impl.regression.LeastSquaresRegression;
import com.opengamma.strata.math.impl.regression.LeastSquaresRegressionResult;
import com.opengamma.strata.math.impl.regression.WeightedLeastSquaresRegressionResult;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedLeastSquaresRegression
extends LeastSquaresRegression {
    private static final Logger log = LoggerFactory.getLogger(WeightedLeastSquaresRegression.class);
    private static CommonsMatrixAlgebra ALGEBRA = new CommonsMatrixAlgebra();

    @Override
    public LeastSquaresRegressionResult regress(double[][] x, double[][] weights, double[] y, boolean useIntercept) {
        if (weights == null) {
            throw new IllegalArgumentException("Cannot perform WLS regression without an array of weights");
        }
        this.checkData(x, weights, y);
        log.info("Have a two-dimensional array for what should be a one-dimensional array of weights. The weights used in this regression will be the diagonal elements only");
        double[] w = new double[weights.length];
        for (int i = 0; i < w.length; ++i) {
            w[i] = weights[i][i];
        }
        return this.regress(x, w, y, useIntercept);
    }

    public LeastSquaresRegressionResult regress(double[][] x, double[] weights, double[] y, boolean useIntercept) {
        if (weights == null) {
            throw new IllegalArgumentException("Cannot perform WLS regression without an array of weights");
        }
        this.checkData(x, weights, y);
        double[][] dep = this.addInterceptVariable(x, useIntercept);
        double[] w = new double[weights.length];
        for (int i = 0; i < y.length; ++i) {
            w[i] = weights[i];
        }
        DoubleMatrix matrix = DoubleMatrix.copyOf((double[][])dep);
        DoubleArray vector = DoubleArray.copyOf((double[])y);
        DiagonalMatrix wDiag = new DiagonalMatrix(w);
        DoubleMatrix transpose = ALGEBRA.getTranspose((Matrix)matrix);
        DoubleMatrix wDiagTimesMatrix = DoubleMatrix.ofUnsafe((double[][])wDiag.multiply((RealMatrix)new Array2DRowRealMatrix(matrix.toArrayUnsafe())).getData());
        DoubleMatrix tmp = (DoubleMatrix)ALGEBRA.multiply((Matrix)ALGEBRA.getInverse(ALGEBRA.multiply((Matrix)transpose, (Matrix)wDiagTimesMatrix)), (Matrix)transpose);
        DoubleMatrix wTmpTimesDiag = DoubleMatrix.copyOf((double[][])wDiag.preMultiply((RealMatrix)new Array2DRowRealMatrix(tmp.toArrayUnsafe())).getData());
        DoubleMatrix betasVector = (DoubleMatrix)ALGEBRA.multiply((Matrix)wTmpTimesDiag, (Matrix)vector);
        double[] yModel = super.writeArrayAsVector(((DoubleMatrix)ALGEBRA.multiply((Matrix)matrix, (Matrix)betasVector)).toArray());
        double[] betas = super.writeArrayAsVector(betasVector.toArray());
        return this.getResultWithStatistics(x, this.convertArray(wDiag.getData()), y, betas, yModel, transpose, matrix, useIntercept);
    }

    private LeastSquaresRegressionResult getResultWithStatistics(double[][] x, double[][] w, double[] y, double[] betas, double[] yModel, DoubleMatrix transpose, DoubleMatrix matrix, boolean useIntercept) {
        double yMean = 0.0;
        for (double y1 : y) {
            yMean += y1;
        }
        yMean /= (double)y.length;
        double totalSumOfSquares = 0.0;
        double errorSumOfSquares = 0.0;
        int n = x.length;
        int k = betas.length;
        double[] residuals = new double[n];
        double[] standardErrorsOfBeta = new double[k];
        double[] tStats = new double[k];
        double[] pValues = new double[k];
        for (int i = 0; i < n; ++i) {
            totalSumOfSquares += w[i][i] * (y[i] - yMean) * (y[i] - yMean);
            residuals[i] = y[i] - yModel[i];
            errorSumOfSquares += w[i][i] * residuals[i] * residuals[i];
        }
        double regressionSumOfSquares = totalSumOfSquares - errorSumOfSquares;
        double[][] covarianceBetas = this.convertArray(ALGEBRA.getInverse(ALGEBRA.multiply((Matrix)transpose, (Matrix)matrix)).toArray());
        double rSquared = regressionSumOfSquares / totalSumOfSquares;
        double adjustedRSquared = 1.0 - (1.0 - rSquared) * (double)(n - 1) / (double)(n - k);
        double meanSquareError = errorSumOfSquares / (double)(n - k);
        TDistribution studentT = new TDistribution((double)(n - k));
        for (int i = 0; i < k; ++i) {
            standardErrorsOfBeta[i] = Math.sqrt(meanSquareError * covarianceBetas[i][i]);
            tStats[i] = betas[i] / standardErrorsOfBeta[i];
            pValues[i] = 1.0 - studentT.cumulativeProbability(Math.abs(tStats[i]));
        }
        return new WeightedLeastSquaresRegressionResult(betas, residuals, meanSquareError, standardErrorsOfBeta, rSquared, adjustedRSquared, tStats, pValues, useIntercept);
    }
}

