/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import java.util.function.Function;

public class BracketRoot {
    private static final double RATIO = 1.6;
    private static final int MAX_STEPS = 50;

    public double[] getBracketedPoints(Function<Double, Double> f, double xLower, double xUpper) {
        ArgChecker.notNull(f, (String)"f");
        double x1 = xLower;
        double x2 = xUpper;
        double f1 = 0.0;
        double f2 = 0.0;
        f1 = f.apply(x1);
        f2 = f.apply(x2);
        if (Double.isNaN(f1)) {
            throw new MathException("Failed to bracket root: function invalid at x = " + x1 + " f(x) = " + f1);
        }
        if (Double.isNaN(f2)) {
            throw new MathException("Failed to bracket root: function invalid at x = " + x2 + " f(x) = " + f2);
        }
        for (int count = 0; count < 50; ++count) {
            if (f1 * f2 < 0.0) {
                return new double[]{x1, x2};
            }
            if (Math.abs(f1) < Math.abs(f2)) {
                if (!Double.isNaN(f1 = f.apply(x1 += 1.6 * (x1 - x2)).doubleValue())) continue;
                throw new MathException("Failed to bracket root: function invalid at x = " + x1 + " f(x) = " + f1);
            }
            if (!Double.isNaN(f2 = f.apply(x2 += 1.6 * (x2 - x1)).doubleValue())) continue;
            throw new MathException("Failed to bracket root: function invalid at x = " + x2 + " f(x) = " + f2);
        }
        throw new MathException("Failed to bracket root");
    }

    public double[] getBracketedPoints(Function<Double, Double> f, double xLower, double xUpper, double minX, double maxX) {
        ArgChecker.notNull(f, (String)"f");
        ArgChecker.isTrue((xLower >= minX ? 1 : 0) != 0, (String)"xLower < minX");
        ArgChecker.isTrue((xUpper <= maxX ? 1 : 0) != 0, (String)"xUpper < maxX");
        double x1 = xLower;
        double x2 = xUpper;
        double f1 = 0.0;
        double f2 = 0.0;
        boolean lowerLimitReached = false;
        boolean upperLimitReached = false;
        f1 = f.apply(x1);
        f2 = f.apply(x2);
        if (Double.isNaN(f1)) {
            throw new MathException("Failed to bracket root: function invalid at x = " + x1 + " f(x) = " + f1);
        }
        if (Double.isNaN(f2)) {
            throw new MathException("Failed to bracket root: function invalid at x = " + x2 + " f(x) = " + f2);
        }
        for (int count = 0; count < 50; ++count) {
            if (f1 * f2 <= 0.0) {
                return new double[]{x1, x2};
            }
            if (lowerLimitReached && upperLimitReached) {
                throw new MathException("Failed to bracket root: no root found between minX and maxX");
            }
            if (Math.abs(f1) < Math.abs(f2) && !lowerLimitReached) {
                if ((x1 += 1.6 * (x1 - x2)) < minX) {
                    x1 = minX;
                    lowerLimitReached = true;
                }
                if (!Double.isNaN(f1 = f.apply(x1).doubleValue())) continue;
                throw new MathException("Failed to bracket root: function invalid at x = " + x1 + " f(x) = " + f1);
            }
            if ((x2 += 1.6 * (x2 - x1)) > maxX) {
                x2 = maxX;
                upperLimitReached = true;
            }
            if (!Double.isNaN(f2 = f.apply(x2).doubleValue())) continue;
            throw new MathException("Failed to bracket root: function invalid at x = " + x2 + " f(x) = " + f2);
        }
        throw new MathException("Failed to bracket root: max iterations");
    }
}

