/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.ComplexNumber;
import com.opengamma.strata.math.impl.function.RealPolynomialFunction1D;
import com.opengamma.strata.math.impl.rootfinding.CubicRootFinder;
import com.opengamma.strata.math.impl.rootfinding.Polynomial1DRootFinder;
import java.util.ArrayList;

public class CubicRealRootFinder
implements Polynomial1DRootFinder<Double> {
    private static final Double[] EMPTY_ARRAY = new Double[0];
    private static final Polynomial1DRootFinder<ComplexNumber> ROOT_FINDER = new CubicRootFinder();

    public Double[] getRoots(RealPolynomialFunction1D function) {
        ArgChecker.notNull((Object)function, (String)"function");
        double[] coefficients = function.getCoefficients();
        if (coefficients.length != 4) {
            throw new IllegalArgumentException("Function is not a cubic");
        }
        ComplexNumber[] result = ROOT_FINDER.getRoots(function);
        ArrayList<Double> reals = new ArrayList<Double>();
        for (ComplexNumber c : result) {
            if (!DoubleMath.fuzzyEquals((double)c.getImaginary(), (double)0.0, (double)1.0E-16)) continue;
            reals.add(c.getReal());
        }
        ArgChecker.isTrue((reals.size() > 0 ? 1 : 0) != 0, (String)"Could not find any real roots");
        return reals.toArray(EMPTY_ARRAY);
    }
}

