/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.impl.function.RealPolynomialFunction1D;
import com.opengamma.strata.math.impl.rootfinding.Polynomial1DRootFinder;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class EigenvaluePolynomialRootFinder
implements Polynomial1DRootFinder<Double> {
    public Double[] getRoots(RealPolynomialFunction1D function) {
        ArgChecker.notNull((Object)function, (String)"function");
        double[] coeffs = function.getCoefficients();
        int l = coeffs.length - 1;
        double[][] hessianDeref = new double[l][l];
        for (int i = 0; i < l; ++i) {
            hessianDeref[0][i] = -coeffs[l - i - 1] / coeffs[l];
            for (int j = 1; j < l; ++j) {
                hessianDeref[j][i] = 0.0;
                if (i == l - 1) continue;
                hessianDeref[i + 1][i] = 1.0;
            }
        }
        Array2DRowRealMatrix hessian = new Array2DRowRealMatrix(hessianDeref);
        double[] d = new EigenDecomposition((RealMatrix)hessian).getRealEigenvalues();
        Double[] result = new Double[d.length];
        for (int i = 0; i < d.length; ++i) {
            result[i] = d[i];
        }
        return result;
    }
}

