/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.function.RealPolynomialFunction1D;
import com.opengamma.strata.math.impl.rootfinding.Polynomial1DRootFinder;
import java.util.ArrayList;
import org.apache.commons.math3.analysis.solvers.LaguerreSolver;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.TooManyEvaluationsException;

public class LaguerrePolynomialRealRootFinder
implements Polynomial1DRootFinder<Double> {
    private static final LaguerreSolver ROOT_FINDER = new LaguerreSolver();
    private static final double EPS = 1.0E-16;

    public Double[] getRoots(RealPolynomialFunction1D function) {
        ArgChecker.notNull((Object)function, (String)"function");
        try {
            Complex[] roots = ROOT_FINDER.solveAllComplex(function.getCoefficients(), 0.0);
            ArrayList<Double> realRoots = new ArrayList<Double>();
            for (Complex c : roots) {
                if (!DoubleMath.fuzzyEquals((double)c.getImaginary(), (double)0.0, (double)1.0E-16)) continue;
                realRoots.add(c.getReal());
            }
            if (realRoots.isEmpty()) {
                throw new MathException("Could not find any real roots");
            }
            return realRoots.toArray(new Double[realRoots.size()]);
        }
        catch (TooManyEvaluationsException e) {
            throw new MathException(e);
        }
    }
}

