/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.function.RealPolynomialFunction1D;
import com.opengamma.strata.math.impl.rootfinding.Polynomial1DRootFinder;

public class QuadraticRealRootFinder
implements Polynomial1DRootFinder<Double> {
    public Double[] getRoots(RealPolynomialFunction1D function) {
        ArgChecker.notNull((Object)function, (String)"function");
        double[] coefficients = function.getCoefficients();
        ArgChecker.isTrue((coefficients.length == 3 ? 1 : 0) != 0, (String)"Function is not a quadratic");
        double c = coefficients[0];
        double b = coefficients[1];
        double a = coefficients[2];
        double discriminant = b * b - 4.0 * a * c;
        if (discriminant < 0.0) {
            throw new MathException("No real roots for quadratic");
        }
        double q = -0.5 * (b + Math.signum(b) * discriminant);
        return new Double[]{q / a, c / q};
    }
}

