/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding;

import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.rootfinding.RealSingleRootFinder;
import com.opengamma.strata.math.impl.util.CommonsMathWrapper;
import java.util.function.Function;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.RiddersSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;

public class RidderSingleRootFinder
extends RealSingleRootFinder {
    private static final int MAX_ITER = 100000;
    private final RiddersSolver _ridder;

    public RidderSingleRootFinder() {
        this(1.0E-15);
    }

    public RidderSingleRootFinder(double functionValueAccuracy) {
        this._ridder = new RiddersSolver(functionValueAccuracy);
    }

    public RidderSingleRootFinder(double functionValueAccuracy, double absoluteAccurary) {
        this._ridder = new RiddersSolver(functionValueAccuracy, absoluteAccurary);
    }

    @Override
    public Double getRoot(Function<Double, Double> function, Double xLow, Double xHigh) {
        this.checkInputs(function, xLow, xHigh);
        UnivariateFunction wrapped = CommonsMathWrapper.wrapUnivariate(function);
        try {
            return this._ridder.solve(100000, wrapped, xLow.doubleValue(), xHigh.doubleValue());
        }
        catch (NoBracketingException | TooManyEvaluationsException e) {
            throw new MathException(e);
        }
    }
}

