/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding.newton;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebraFactory;
import com.opengamma.strata.math.impl.rootfinding.newton.NewtonRootFinderMatrixUpdateFunction;
import java.util.function.Function;

public class BroydenMatrixUpdateFunction
implements NewtonRootFinderMatrixUpdateFunction {
    @Override
    public DoubleMatrix getUpdatedMatrix(Function<DoubleArray, DoubleMatrix> j, DoubleArray x, DoubleArray deltaX, DoubleArray deltaY, DoubleMatrix matrix) {
        ArgChecker.notNull((Object)deltaX, (String)"deltaX");
        ArgChecker.notNull((Object)deltaY, (String)"deltaY");
        ArgChecker.notNull((Object)matrix, (String)"matrix");
        double length2 = MatrixAlgebraFactory.OG_ALGEBRA.getInnerProduct((Matrix)deltaX, (Matrix)deltaX);
        if (length2 == 0.0) {
            return matrix;
        }
        Matrix temp = MatrixAlgebraFactory.OG_ALGEBRA.subtract((Matrix)deltaY, MatrixAlgebraFactory.OG_ALGEBRA.multiply((Matrix)matrix, (Matrix)deltaX));
        temp = MatrixAlgebraFactory.OG_ALGEBRA.scale(temp, 1.0 / length2);
        return (DoubleMatrix)MatrixAlgebraFactory.OG_ALGEBRA.add((Matrix)matrix, (Matrix)MatrixAlgebraFactory.OG_ALGEBRA.getOuterProduct(temp, (Matrix)deltaX));
    }
}

