/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding.newton;

import com.opengamma.strata.math.impl.linearalgebra.LUDecompositionCommons;
import com.opengamma.strata.math.impl.rootfinding.newton.BaseNewtonVectorRootFinder;
import com.opengamma.strata.math.impl.rootfinding.newton.BroydenMatrixUpdateFunction;
import com.opengamma.strata.math.impl.rootfinding.newton.JacobianDirectionFunction;
import com.opengamma.strata.math.impl.rootfinding.newton.JacobianEstimateInitializationFunction;
import com.opengamma.strata.math.linearalgebra.Decomposition;

public class BroydenVectorRootFinder
extends BaseNewtonVectorRootFinder {
    private static final double DEF_TOL = 1.0E-7;
    private static final int MAX_STEPS = 100;

    public BroydenVectorRootFinder() {
        this(1.0E-7, 1.0E-7, 100);
    }

    public BroydenVectorRootFinder(Decomposition<?> decomp) {
        this(1.0E-7, 1.0E-7, 100, decomp);
    }

    public BroydenVectorRootFinder(double absoluteTol, double relativeTol, int maxSteps) {
        this(absoluteTol, relativeTol, maxSteps, new LUDecompositionCommons());
    }

    public BroydenVectorRootFinder(double absoluteTol, double relativeTol, int maxSteps, Decomposition<?> decomp) {
        super(absoluteTol, relativeTol, maxSteps, new JacobianDirectionFunction(decomp), new JacobianEstimateInitializationFunction(), new BroydenMatrixUpdateFunction());
    }
}

