/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.rootfinding.newton;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.rootfinding.newton.NewtonRootFinderMatrixUpdateFunction;
import java.util.function.Function;

public class ShermanMorrisonMatrixUpdateFunction
implements NewtonRootFinderMatrixUpdateFunction {
    private final MatrixAlgebra _algebra;

    public ShermanMorrisonMatrixUpdateFunction(MatrixAlgebra algebra) {
        ArgChecker.notNull((Object)algebra, (String)"algebra");
        this._algebra = algebra;
    }

    @Override
    public DoubleMatrix getUpdatedMatrix(Function<DoubleArray, DoubleMatrix> g, DoubleArray x, DoubleArray deltaX, DoubleArray deltaY, DoubleMatrix matrix) {
        ArgChecker.notNull((Object)deltaX, (String)"deltaX");
        ArgChecker.notNull((Object)deltaY, (String)"deltaY");
        ArgChecker.notNull((Object)matrix, (String)"matrix");
        DoubleArray v1 = (DoubleArray)this._algebra.multiply((Matrix)deltaX, (Matrix)matrix);
        double length = this._algebra.getInnerProduct((Matrix)v1, (Matrix)deltaY);
        if (length == 0.0) {
            return matrix;
        }
        v1 = (DoubleArray)this._algebra.scale((Matrix)v1, 1.0 / length);
        DoubleArray v2 = (DoubleArray)this._algebra.subtract((Matrix)deltaX, this._algebra.multiply((Matrix)matrix, (Matrix)deltaY));
        DoubleMatrix m = this._algebra.getOuterProduct((Matrix)v2, (Matrix)v1);
        return (DoubleMatrix)this._algebra.add((Matrix)matrix, (Matrix)m);
    }
}

