/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.math.impl.statistics.descriptive;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.statistics.descriptive.QuantileCalculationMethod;
import com.opengamma.strata.math.impl.statistics.descriptive.QuantileResult;

public abstract class DiscreteQuantileMethod
extends QuantileCalculationMethod {
    @Override
    protected QuantileResult quantile(double level, DoubleArray sample, boolean isExtrapolated) {
        ArgChecker.isTrue((level > 0.0 ? 1 : 0) != 0, (String)"Quantile should be above 0.");
        ArgChecker.isTrue((level < 1.0 ? 1 : 0) != 0, (String)"Quantile should be below 1.");
        int sampleSize = this.sampleCorrection(sample.size());
        double[] order = this.createIndexArray(sample.size());
        double[] s = sample.toArray();
        DoubleArrayMath.sortPairs((double[])s, (double[])order);
        int index = (int)this.checkIndex(this.index(level * (double)sampleSize), sample.size(), isExtrapolated);
        int[] ind = new int[]{(int)order[index - 1]};
        return QuantileResult.of(s[index - 1], ind, DoubleArray.of((double)1.0));
    }

    @Override
    protected QuantileResult expectedShortfall(double level, DoubleArray sample) {
        ArgChecker.isTrue((level > 0.0 ? 1 : 0) != 0, (String)"Quantile should be above 0.");
        ArgChecker.isTrue((level < 1.0 ? 1 : 0) != 0, (String)"Quantile should be below 1.");
        int sampleSize = this.sampleCorrection(sample.size());
        double[] order = this.createIndexArray(sample.size());
        double[] s = sample.toArray();
        DoubleArrayMath.sortPairs((double[])s, (double[])order);
        double fractionalIndex = level * (double)sampleSize;
        int index = (int)this.checkIndex(this.index(fractionalIndex), sample.size(), true);
        int[] indices = new int[index];
        double[] weights = new double[index];
        double interval = 1.0 / (double)sampleSize;
        double losses = s[0] * interval * this.indexShift();
        for (int i = 0; i < index - 1; ++i) {
            losses += s[i] * interval;
            indices[i] = (int)order[i];
            weights[i] = interval;
        }
        indices[index - 1] = (int)order[index - 1];
        weights[0] = weights[0] + interval * this.indexShift();
        weights[index - 1] = (fractionalIndex - (double)index + 1.0 - this.indexShift()) * interval;
        return QuantileResult.of((losses += s[index - 1] * (fractionalIndex - (double)index + 1.0 - this.indexShift()) * interval) / level, indices, DoubleArray.ofUnsafe((double[])weights).dividedBy(level));
    }

    abstract int index(double var1);

    abstract int sampleCorrection(int var1);

    abstract double indexShift();

    private double[] createIndexArray(int indexArrayLength) {
        double[] indexArray = new double[indexArrayLength];
        for (int i = 0; i < indexArrayLength; ++i) {
            indexArray[i] = i;
        }
        return indexArray;
    }
}

